/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.core;

import jasima.core.util.TypeUtil;
import jasima.core.util.ValueStore;
import jasima.core.util.ValueStoreImpl;
import jasima.core.util.observer.Notifier;
import jasima.core.util.observer.NotifierImpl;
import jasima.shopSim.core.Operation;
import jasima.shopSim.core.PrioRuleTarget;
import jasima.shopSim.core.Route;
import jasima.shopSim.core.Shop;
import jasima.shopSim.core.WorkStation;

public class Job
extends PrioRuleTarget
implements Cloneable,
ValueStore,
Notifier<Job, JobEvent> {
    private final Shop shop;
    private NotifierImpl<Job, JobEvent> notifierAdapter;
    private ValueStoreImpl valueStore;
    private double arriveTime;
    private WorkStation currMachine;
    private double startTime;
    private double finishTime;
    private double relDate;
    private double dueDate;
    private int jobNum;
    private int jobType;
    private double weight = 1.0;
    private int taskNumber;
    private Operation[] ops;
    private double[] opDueDates;
    private boolean isFuture = false;
    private String name = null;
    private Route route = null;
    private double remProcTime = -1.0;
    private Job future;

    public Job(Shop shop) {
        this.shop = shop;
        this.notifierAdapter = new NotifierImpl(this);
        this.valueStore = new ValueStoreImpl();
    }

    public void setArriveTime(double fl) {
        this.arriveTime = fl;
    }

    @Override
    public double getArriveTime() {
        return this.arriveTime;
    }

    public void setJobType(int job) {
        this.jobType = job;
    }

    public int getJobType() {
        return this.jobType;
    }

    public void setTaskNumber(int tn) {
        this.remProcTime = -1.0;
        this.taskNumber = tn;
    }

    @Override
    public int getTaskNumber() {
        return this.taskNumber;
    }

    public void setCurrMachine(WorkStation currMachine) {
        this.currMachine = currMachine;
    }

    @Override
    public WorkStation getCurrMachine() {
        return this.currMachine;
    }

    @Override
    public Operation getCurrentOperation() {
        return this.ops[this.taskNumber];
    }

    @Override
    public double currProcTime() {
        return this.ops[this.taskNumber].getProcTime();
    }

    @Override
    public double procSum() {
        double res = 0.0;
        for (Operation o : this.ops) {
            res += o.getProcTime();
        }
        return res;
    }

    @Override
    public double remainingProcTime() {
        if (this.remProcTime < 0.0) {
            this.remProcTime = 0.0;
            Operation[] ops = this.ops;
            for (int i = this.taskNumber; i < ops.length; ++i) {
                this.remProcTime += ops[i].getProcTime();
            }
        }
        return this.remProcTime;
    }

    @Override
    public int numOps() {
        return this.getOps().length;
    }

    @Override
    public int numOpsLeft() {
        return this.getOps().length - this.getTaskNumber();
    }

    void proceed() {
        if (!this.isLastOperation()) {
            this.setTaskNumber(this.getTaskNumber() + 1);
            WorkStation mNext = this.ops[this.taskNumber].getMachine();
            mNext.enqueueOrProcess(this);
        } else {
            this.shop.jobFinished(this);
        }
    }

    void jobReleased() {
        if (this.numListener() > 0) {
            this.fire(JobMessage.JOB_RELEASED);
        }
    }

    void jobFinished() {
        if (this.numListener() > 0) {
            this.fire(JobMessage.JOB_FINISHED);
        }
    }

    void arriveInQueue(WorkStation workStation, double arrivesAt) {
        this.setCurrMachine(workStation);
        this.setArriveTime(arrivesAt);
        if (this.numListener() > 0) {
            this.fire(JobMessage.JOB_ARRIVED_IN_QUEUE);
        }
    }

    void removedFromQueue() {
        if (this.numListener() > 0) {
            this.fire(JobMessage.JOB_REMOVED_FROM_QUEUE);
        }
    }

    void startProcessing() {
        this.setFinishTime(this.currMachine.currMachine.procFinished);
        this.setStartTime(this.currMachine.shop().simTime());
        this.notifyNextMachine();
        if (this.numListener() > 0) {
            this.fire(JobMessage.JOB_START_OPERATION);
        }
    }

    void endProcessing() {
        if (this.numListener() > 0) {
            this.fire(JobMessage.JOB_END_OPERATION);
        }
    }

    public void notifyNextMachine() {
        if (!this.isLastOperation() && this.shop.isEnableLookAhead()) {
            Job f = this.getMyFuture();
            WorkStation next = f.ops[f.taskNumber].getMachine();
            next.futureArrival(f, this.getFinishTime());
        }
    }

    public Job getMyFuture() {
        if (this.future == null) {
            this.future = this.clone();
            this.future.setFuture(true);
        }
        this.future.setTaskNumber(this.taskNumber + 1);
        return this.future;
    }

    void setFuture(boolean isFuture) {
        this.isFuture = isFuture;
    }

    @Override
    public boolean isFuture() {
        return this.isFuture;
    }

    public boolean isLastOperation() {
        return this.taskNumber == this.ops.length - 1;
    }

    public String toString() {
        String s = this.getName() + "#" + this.taskNumber;
        if (this.isFuture()) {
            s = s + "(future)";
        }
        return s;
    }

    @Override
    public Shop getShop() {
        return this.shop;
    }

    @Override
    public double getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(double dueDate) {
        this.dueDate = dueDate;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public Job getFuture() {
        return this.future;
    }

    public void setFuture(Job future) {
        this.future = future;
    }

    public void setRelDate(double relDate) {
        this.relDate = relDate;
    }

    @Override
    public double getRelDate() {
        return this.relDate;
    }

    public void setJobNum(int jobNum) {
        this.jobNum = jobNum;
    }

    @Override
    public int getJobNum() {
        return this.jobNum;
    }

    public void setFinishTime(double finishTime) {
        this.finishTime = finishTime;
    }

    public double getFinishTime() {
        return this.finishTime;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public void setStartTime(double startTime) {
        this.startTime = startTime;
    }

    public void setOpDueDates(double[] opDueDates) {
        this.opDueDates = opDueDates;
    }

    public double[] getOpDueDates() {
        return this.opDueDates;
    }

    @Override
    public double getCurrentOperationDueDate() {
        if (this.opDueDates == null) {
            this.setOpDueDates(Job.computeDueDatesTWC(this, (this.dueDate - this.relDate) / this.procSum()));
        }
        return this.opDueDates[this.taskNumber];
    }

    public void setOps(Operation[] ops) {
        this.ops = ops;
        this.opDueDates = null;
    }

    @Override
    public Operation[] getOps() {
        return this.ops;
    }

    @Override
    public Job job(int i) {
        if (i != 0) {
            throw new IllegalArgumentException("" + i);
        }
        return this;
    }

    @Override
    public int numJobsInBatch() {
        return 1;
    }

    public static double[] computeDueDatesTWC(Job j, double ff) {
        Operation[] ops = j.ops;
        double[] res = new double[ops.length];
        double due = j.getRelDate();
        for (int i = 0; i < res.length; ++i) {
            res[i] = due += ff * ops[i].getProcTime();
        }
        return res;
    }

    @Override
    public boolean isBatch() {
        return false;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            return this.getClass().getSimpleName() + "." + this.jobType + "." + this.getJobNum();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Route getRoute() {
        return this.route;
    }

    public void setRoute(Route route) {
        this.route = route;
    }

    @Override
    public ValueStore valueStoreImpl() {
        return this.valueStore;
    }

    @Override
    public Notifier<Job, JobEvent> notifierImpl() {
        return this.notifierAdapter;
    }

    public Job clone() {
        try {
            Job j = (Job)super.clone();
            j.future = null;
            j.valueStore = this.valueStore.clone();
            j.notifierAdapter = new NotifierImpl(j);
            for (int i = 0; i < this.numListener(); ++i) {
                j.addListener(TypeUtil.cloneIfPossible(this.getListener(i)));
            }
            return j;
        }
        catch (CloneNotSupportedException shouldNeverOccur) {
            throw new AssertionError((Object)shouldNeverOccur);
        }
    }

    public static enum JobMessage implements JobEvent
    {
        JOB_RELEASED,
        JOB_FINISHED,
        JOB_ARRIVED_IN_QUEUE,
        JOB_REMOVED_FROM_QUEUE,
        JOB_START_OPERATION,
        JOB_END_OPERATION;

    }

    public static interface JobEvent {
    }
}

