/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.core;

import jasima.core.simulation.SimEvent;
import jasima.shopSim.core.DowntimeSource;
import jasima.shopSim.core.PrioRuleTarget;
import jasima.shopSim.core.Shop;
import jasima.shopSim.core.WorkStation;
import java.util.Collections;
import java.util.List;

public class IndividualMachine {
    public final WorkStation workStation;
    public final int idx;
    public double relDate;
    public int initialSetup;
    public String name = null;
    public List<? extends DowntimeSource> downsources = Collections.EMPTY_LIST;
    public MachineState state;
    public DowntimeSource downReason;
    public double procStarted;
    public double procFinished;
    public int setupState;
    public PrioRuleTarget curJob;
    SimEvent onDepart = new SimEvent(0.0, -1073741822){

        @Override
        public void handle() {
            IndividualMachine.this.workStation.currMachine = IndividualMachine.this;
            IndividualMachine.this.workStation.depart();
            IndividualMachine.this.workStation.currMachine = null;
        }
    };

    public IndividualMachine(WorkStation workStation, int idx) {
        this.workStation = workStation;
        this.idx = idx;
        this.state = MachineState.DOWN;
        this.initialSetup = 0;
        this.relDate = 0.0;
    }

    public void activate() {
        if (this.state != MachineState.DOWN) {
            throw new IllegalStateException("Only a machine in state DOWN can be activated .");
        }
        assert (this.curJob == null);
        this.state = MachineState.IDLE;
        this.procFinished = -1.0;
        this.procStarted = -1.0;
        this.workStation.activated(this);
        this.downReason = null;
    }

    public void takeDown(DowntimeSource downReason) {
        Shop shop = this.workStation.shop();
        if (this.state != MachineState.IDLE) {
            assert (this.procFinished >= shop.simTime());
            assert (this.curJob != null || this.state == MachineState.DOWN);
            shop.getSim().scheduleAt(this.procFinished, -1073740822, () -> {
                assert (this.workStation.currMachine == null);
                this.workStation.currMachine = this;
                this.takeDown(downReason);
                this.workStation.currMachine = null;
            });
        } else {
            assert (this.state == MachineState.IDLE);
            this.procStarted = shop.simTime();
            this.procFinished = shop.simTime();
            this.state = MachineState.DOWN;
            this.downReason = downReason;
            this.curJob = null;
            this.workStation.takenDown(this);
        }
    }

    protected void init() {
        this.setupState = this.initialSetup;
        this.procFinished = this.relDate;
        this.procStarted = 0.0;
        this.state = MachineState.DOWN;
        this.workStation.getSim().scheduleAt(this.relDate, -1073742822, () -> {
            assert (this.workStation.currMachine == null);
            this.workStation.currMachine = this;
            this.activate();
            this.workStation.currMachine = null;
        });
        for (DowntimeSource downtimeSource : this.downsources) {
            downtimeSource.init();
        }
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        if (this.name == null) {
            return this.workStation.getName() + (this.workStation.numInGroup() > 1 ? "." + this.idx : "");
        }
        return this.name;
    }

    public static enum MachineState {
        DOWN,
        IDLE,
        WORKING;

    }
}

