/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.core;

import jasima.core.random.RandomFactory;
import jasima.core.random.continuous.DblConst;
import jasima.core.random.continuous.DblSequence;
import jasima.core.random.discrete.IntSequence;
import jasima.core.simulation.SimComponentContainer;
import jasima.core.simulation.arrivalprocess.ArrivalsStationary;
import jasima.shopSim.core.Job;
import jasima.shopSim.core.JobSource;
import jasima.shopSim.core.Operation;
import jasima.shopSim.core.Route;
import jasima.shopSim.core.WorkStation;

public class DynamicJobSource
extends JobSource {
    private DblSequence arrivalProcess = new ArrivalsStationary();
    private DblSequence dueDateFactors = new DblConst(1.0);
    private DblSequence jobWeights = new DblConst(1.0);
    private IntSequence machIdx = null;
    private DblSequence procTimes = null;
    private IntSequence numOps = null;
    private Route route = null;

    @Override
    public void init() {
        String prefix = "source" + this.index + ".";
        super.init();
        RandomFactory fact = this.getSim().getRndStreamFactory();
        DynamicJobSource.init(this.getArrivalProcess(), prefix + "arrivalStream", fact);
        DynamicJobSource.init(this.getDueDateFactors(), prefix + "dueDateStream", fact);
        DynamicJobSource.init(this.getJobWeights(), prefix + "weightStream", fact);
        DynamicJobSource.init(this.getMachIdx(), prefix + "machIdxStream", fact);
        DynamicJobSource.init(this.getProcTimes(), prefix + "procTimesStream", fact);
        DynamicJobSource.init(this.getNumOps(), prefix + "numOpsStream", fact);
    }

    protected static void init(DblSequence dblStream, String streamName, RandomFactory fact) {
        if (dblStream == null) {
            return;
        }
        fact.initRndGen(dblStream, streamName);
    }

    @Override
    public Job createNextJob() {
        Job j = this.newJobInstance();
        j.setJobType(this.index);
        j.setOps(this.getRouteForJob());
        j.setRoute(this.route);
        j.setRelDate(this.getArrivalProcess().nextDbl());
        j.setDueDate(j.getRelDate() + this.getDueDateFactors().nextDbl() * j.procSum());
        j.setWeight(this.getJobWeights().nextDbl());
        return j;
    }

    protected Operation[] getRouteForJob() {
        return this.route != null ? this.route.ops() : this.createRoute();
    }

    protected Operation[] createRoute() {
        int n;
        SimComponentContainer machines = this.getShop().machines();
        int n2 = n = this.getNumOps() != null ? this.getNumOps().nextInt() : machines.numChildren();
        assert (n > 0);
        Operation[] ops = new Operation[n];
        boolean[] machineChosen = new boolean[machines.numChildren()];
        for (int i = 0; i < n; ++i) {
            int mi = -1;
            while (machineChosen[mi = this.getMachIdx().nextInt()]) {
            }
            WorkStation m = (WorkStation)machines.getChild(mi);
            machineChosen[mi] = true;
            Operation o = ops[i] = new Operation();
            o.setMachine(m);
            o.setProcTime(this.getProcTimes().nextDbl());
        }
        return ops;
    }

    public void setDueDateFactors(DblSequence dueDateFactors) {
        this.dueDateFactors = dueDateFactors;
    }

    public DblSequence getDueDateFactors() {
        return this.dueDateFactors;
    }

    public void setJobWeights(DblSequence jobWeights) {
        this.jobWeights = jobWeights;
    }

    public DblSequence getJobWeights() {
        return this.jobWeights;
    }

    public Route getRoute() {
        return this.route;
    }

    public void setRoute(Route route) {
        this.route = route;
    }

    public void setMachIdx(IntSequence machIdx) {
        this.machIdx = machIdx;
    }

    public IntSequence getMachIdx() {
        return this.machIdx;
    }

    public void setProcTimes(DblSequence procTimes) {
        this.procTimes = procTimes;
    }

    public DblSequence getProcTimes() {
        return this.procTimes;
    }

    public void setNumOps(IntSequence numOps) {
        this.numOps = numOps;
    }

    public IntSequence getNumOps() {
        return this.numOps;
    }

    public DblSequence getArrivalProcess() {
        return this.arrivalProcess;
    }

    public void setArrivalProcess(DblSequence arrivalProcess) {
        this.arrivalProcess = arrivalProcess;
    }
}

