/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.core;

import jasima.core.random.RandomFactory;
import jasima.core.random.continuous.DblSequence;
import jasima.core.simulation.SimComponent;
import jasima.shopSim.core.IndividualMachine;
import jasima.shopSim.core.Shop;
import jasima.shopSim.core.WorkStation;
import jasima.shopSim.core.WorkStationListener;

public class DowntimeSource {
    private final IndividualMachine machine;
    private DblSequence timeBetweenFailures;
    private DblSequence timeToRepair;
    private String name;

    public DowntimeSource(IndividualMachine machine) {
        this.machine = machine;
    }

    public void init() {
        RandomFactory fact = this.machine.workStation.getSim().getRndStreamFactory();
        if (this.timeBetweenFailures != null && this.timeBetweenFailures.getRndGen() == null) {
            fact.initRndGen(this.timeBetweenFailures, this.toString() + ".timeBetweenFailures");
        }
        if (this.timeToRepair != null && this.timeToRepair.getRndGen() == null) {
            fact.initRndGen(this.timeToRepair, this.toString() + ".timeToRepair");
        }
        WorkStationListener wsl = new WorkStationListener(){

            @Override
            public void activated(WorkStation m, IndividualMachine justActivated) {
                if (justActivated == DowntimeSource.this.machine && ((DowntimeSource)DowntimeSource.this).machine.downReason == DowntimeSource.this) {
                    DowntimeSource.this.onActivate();
                }
            }

            @Override
            public void deactivated(WorkStation m, IndividualMachine justDeactivated) {
                if (justDeactivated == DowntimeSource.this.machine && ((DowntimeSource)DowntimeSource.this).machine.downReason == DowntimeSource.this) {
                    DowntimeSource.this.onDeactivate();
                }
            }

            @Override
            public void done(SimComponent m) {
                ((DowntimeSource)DowntimeSource.this).machine.workStation.removeListener(this);
            }
        };
        this.machine.workStation.addListener(wsl);
        this.onActivate();
    }

    protected void onActivate() {
        if (this.isSourceActive()) {
            Shop shop = this.machine.workStation.shop();
            double nextFailure = this.calcDeactivateTime(shop);
            shop.getSim().scheduleAt(nextFailure, -1073740822, () -> {
                assert (this.machine.workStation.currMachine == null);
                this.machine.workStation.currMachine = this.machine;
                this.machine.takeDown(this);
                this.machine.workStation.currMachine = null;
            });
        }
    }

    protected boolean isSourceActive() {
        return this.timeBetweenFailures != null;
    }

    protected void onDeactivate() {
        double whenReactivated;
        Shop shop = this.machine.workStation.shop();
        this.machine.procFinished = whenReactivated = this.calcActivateTime(shop);
        shop.getSim().scheduleAt(whenReactivated, -1073742822, () -> {
            assert (this.machine.workStation.currMachine == null);
            this.machine.workStation.currMachine = this.machine;
            this.machine.activate();
            this.machine.workStation.currMachine = null;
        });
    }

    protected double calcDeactivateTime(Shop shop) {
        return shop.simTime() + this.ensurePositiveNumber(this.timeBetweenFailures);
    }

    protected double calcActivateTime(Shop shop) {
        return shop.simTime() + this.ensurePositiveNumber(this.timeToRepair);
    }

    protected double ensurePositiveNumber(DblSequence dblStream) {
        double ttr;
        while ((ttr = dblStream.nextDbl()) < 0.0) {
        }
        return ttr;
    }

    public String toString() {
        return "downSource." + String.valueOf(this.machine) + (this.name != null ? "." + this.name : "");
    }

    public DblSequence getTimeBetweenFailures() {
        return this.timeBetweenFailures;
    }

    public void setTimeBetweenFailures(DblSequence timeBetweenFailures) {
        this.timeBetweenFailures = timeBetweenFailures;
    }

    public DblSequence getTimeToRepair() {
        return this.timeToRepair;
    }

    public void setTimeToRepair(DblSequence timeToRepair) {
        this.timeToRepair = timeToRepair;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IndividualMachine getMachine() {
        return this.machine;
    }
}

