/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.core;

import jasima.core.util.ValueStore;
import jasima.core.util.ValueStoreImpl;
import jasima.shopSim.core.Job;
import jasima.shopSim.core.Operation;
import jasima.shopSim.core.PrioRuleTarget;
import jasima.shopSim.core.Shop;
import jasima.shopSim.core.WorkStation;
import java.util.ArrayList;

public class Batch
extends PrioRuleTarget {
    public final Shop shop;
    private ValueStoreImpl valueStore;
    private static final String SEPARATOR = ",";
    private final ArrayList<Job> jobsInBatch;
    private int numFutures;
    private String name = null;
    public Operation op;

    public Batch(Shop shop) {
        this.shop = shop;
        this.jobsInBatch = new ArrayList();
        this.numFutures = 0;
    }

    public void addToBatch(Job job) {
        assert (!this.jobsInBatch.contains(job));
        this.jobsInBatch.add(job);
        if (job.isFuture()) {
            ++this.numFutures;
        }
    }

    public void clear() {
        this.jobsInBatch.clear();
        this.numFutures = 0;
    }

    @Override
    public int numJobsInBatch() {
        return this.jobsInBatch.size();
    }

    @Override
    public Job job(int i) {
        return this.jobsInBatch.get(i);
    }

    @Override
    public boolean isFuture() {
        return this.numFutures > 0;
    }

    public Batch createCopy() {
        Batch clone = new Batch(this.shop);
        for (Job j : this.jobsInBatch) {
            clone.addToBatch(j);
        }
        return clone;
    }

    @Override
    public ValueStore valueStoreImpl() {
        return this.valueStore;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (Job j : this.jobsInBatch) {
            sb.append(j.toString()).append(SEPARATOR);
        }
        return (this.getName() != null ? this.getName() : this.op.getBatchFamily()) + "_{" + sb.substring(0, sb.length() - SEPARATOR.length()) + "}";
    }

    public double getEarliestODD() {
        double dueDate = Double.POSITIVE_INFINITY;
        for (Job j : this.jobsInBatch) {
            if (!(j.getCurrentOperationDueDate() < dueDate)) continue;
            dueDate = j.getCurrentOperationDueDate();
        }
        return dueDate;
    }

    public double getTotalWeight() {
        double totWeight = 0.0;
        for (Job j : this.jobsInBatch) {
            totWeight += j.getWeight();
        }
        return totWeight;
    }

    @Override
    public double currProcTime() {
        return this.op.getProcTime();
    }

    @Override
    public double getArriveTime() {
        double res = Double.NEGATIVE_INFINITY;
        for (Job j : this.jobsInBatch) {
            if (!(j.getArriveTime() > res)) continue;
            res = j.getArriveTime();
        }
        assert (res != Double.NEGATIVE_INFINITY);
        return res;
    }

    @Override
    public WorkStation getCurrMachine() {
        return this.op.getMachine();
    }

    @Override
    public Operation getCurrentOperation() {
        return this.op;
    }

    @Override
    public double getDueDate() {
        double res = this.jobsInBatch.get(0).getDueDate();
        int n = this.jobsInBatch.size();
        for (int i = 1; i < n; ++i) {
            Job j = this.jobsInBatch.get(i);
            res += j.getDueDate();
        }
        return res / (double)this.jobsInBatch.size();
    }

    @Override
    public int getJobNum() {
        int res = this.jobsInBatch.get(0).getJobNum();
        int n = this.jobsInBatch.size();
        for (int i = 1; i < n; ++i) {
            Job j = this.jobsInBatch.get(i);
            if (res >= j.getJobNum()) continue;
            res = j.getJobNum();
        }
        return res;
    }

    @Override
    public double getCurrentOperationDueDate() {
        double res = this.jobsInBatch.get(0).getCurrentOperationDueDate();
        int n = this.jobsInBatch.size();
        for (int i = 1; i < n; ++i) {
            Job j = this.jobsInBatch.get(i);
            res += j.getCurrentOperationDueDate();
        }
        return res / (double)this.jobsInBatch.size();
    }

    @Override
    public Operation[] getOps() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getRelDate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Shop getShop() {
        return this.op.getMachine().shop();
    }

    @Override
    public int getTaskNumber() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getWeight() {
        double res = this.jobsInBatch.get(0).getWeight();
        int n = this.jobsInBatch.size();
        for (int i = 1; i < n; ++i) {
            Job j = this.jobsInBatch.get(i);
            res += j.getWeight();
        }
        return res / (double)this.jobsInBatch.size();
    }

    @Override
    public int numOps() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int numOpsLeft() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double procSum() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double remainingProcTime() {
        double res = this.jobsInBatch.get(0).remainingProcTime();
        int n = this.jobsInBatch.size();
        for (int i = 1; i < n; ++i) {
            Job j = this.jobsInBatch.get(i);
            res += j.remainingProcTime();
        }
        return res / (double)this.jobsInBatch.size();
    }

    @Override
    public boolean isBatch() {
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

