/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.util.observer;

import jasima.core.util.observer.ConstValue;
import jasima.core.util.observer.DerivedObservable;
import jasima.core.util.observer.ObservableValue;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public final class ObservableValues {
    public static final ObservableValue<Boolean> TRUE = new ConstValue<Boolean>(Boolean.TRUE);
    public static final ObservableValue<Boolean> FALSE = new ConstValue<Boolean>(Boolean.FALSE);

    public static <T> ObservableValue<T> observable(T initialValue) {
        return new ObservableValue<T>(initialValue);
    }

    public static <T> ObservableValue<T> observable(String name, T initialValue) {
        return new ObservableValue<T>(initialValue);
    }

    public static <T> DerivedObservable<T> derived(Supplier<T> expression, ObservableValue<?> ... dependencies) {
        return new DerivedObservable<T>(expression, dependencies);
    }

    public static <T> DerivedObservable<T> derived(String name, Supplier<T> expression, ObservableValue<?> ... dependencies) {
        return new DerivedObservable<T>(expression, dependencies);
    }

    public static <T> DerivedObservable<Boolean> isEqual(ObservableValue<? extends T> v1, ObservableValue<? extends T> v2) {
        Objects.requireNonNull(v1);
        Objects.requireNonNull(v2);
        return ObservableValues.derived(() -> v1.equals(v2), v1, v2);
    }

    public static <T, T2 extends T> DerivedObservable<Boolean> isEqual(ObservableValue<? extends T> v1, T2 v2) {
        Objects.requireNonNull(v1);
        return ObservableValues.derived(() -> v1.equals(v2), v1);
    }

    public static <T, T2 extends T> DerivedObservable<Boolean> isEqual(T2 v1, ObservableValue<? extends T> v2) {
        return ObservableValues.isEqual(v2, v1);
    }

    public static ObservableValue.ObservableListener<Boolean> whenTrueExecuteOnce(ObservableValue<Boolean> ov, Runnable action) {
        boolean currentValue;
        Objects.requireNonNull(ov);
        Objects.requireNonNull(action);
        Boolean v = ov.get();
        boolean bl = currentValue = v == null ? false : v;
        if (currentValue) {
            action.run();
            return null;
        }
        AtomicReference<ObservableValue.ObservableListener<Boolean>> listener = new AtomicReference<ObservableValue.ObservableListener<Boolean>>();
        listener.set(ov.addListener((ob, evt) -> {
            boolean v2;
            Boolean v2Orig = (Boolean)ov.get();
            boolean bl = v2 = v2Orig == null ? false : v2Orig;
            if (v2) {
                try {
                    action.run();
                }
                finally {
                    boolean removeRes = ov.removeListener((ObservableValue.ObservableListener)listener.get());
                    assert (removeRes);
                }
            }
        }));
        return (ObservableValue.ObservableListener)listener.get();
    }

    public static DerivedObservable<Boolean> and(ObservableValue<Boolean> v1, ObservableValue<Boolean> v2) {
        return ObservableValues.fromBinaryOperation((b1, b2) -> b1 != false && b2 != false, v1, v2);
    }

    public static DerivedObservable<Boolean> or(ObservableValue<Boolean> v1, ObservableValue<Boolean> v2) {
        return ObservableValues.fromBinaryOperation((b1, b2) -> b1 != false || b2 != false, v1, v2);
    }

    public static DerivedObservable<Boolean> not(ObservableValue<Boolean> v) {
        return ObservableValues.fromUnaryOperation(b -> b == false, v);
    }

    public static <T1, T2, R> DerivedObservable<R> fromBinaryOperation(BiFunction<T1, T2, R> operation, ObservableValue<? extends T1> v1, ObservableValue<? extends T2> v2) {
        Objects.requireNonNull(v1);
        Objects.requireNonNull(v2);
        return ObservableValues.derived(() -> operation.apply(v1.get(), v2.get()), v1, v2);
    }

    public static <T, R> DerivedObservable<R> fromUnaryOperation(Function<T, R> operation, ObservableValue<? extends T> v) {
        Objects.requireNonNull(v);
        return ObservableValues.derived(() -> operation.apply(v.get()), v);
    }

    private ObservableValues() {
        throw new AssertionError();
    }
}

