/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.util.observer;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.function.Supplier;

public class ObservableValue<VALUE> {
    private VALUE currentValue;
    private VALUE lastValue;
    private long versionId;
    private List<Supplier<ObservableListener<VALUE>>> listenerRefs;
    private Map<ObservableListener<VALUE>, Supplier<ObservableListener<VALUE>>> supplierLookup;
    private int firingInProgress;
    private List<ObservableListener<VALUE>> removeWhileFiring;

    public ObservableValue() {
        this(null);
    }

    public ObservableValue(VALUE initialValue) {
        this.currentValue = initialValue;
        this.firingInProgress = 0;
    }

    public VALUE get() {
        return this.currentValue;
    }

    public VALUE getLastValue() {
        return this.lastValue;
    }

    public void set(VALUE newValue) {
        this.internalSet(newValue);
    }

    public ObservableValue<VALUE> update(Function<VALUE, VALUE> updateFunc) {
        this.set(updateFunc.apply(this.get()));
        return this;
    }

    protected void internalSet(VALUE newValue) {
        if (!Objects.equals(this.currentValue, newValue)) {
            this.lastValue = this.currentValue;
            this.currentValue = newValue;
            ++this.versionId;
            if (this.numListener() > 0 && !this.isStale()) {
                this.fireEvent(EventType.VALUE_CHANGED);
            }
        }
    }

    public long versionId() {
        return this.versionId;
    }

    public boolean isStale() {
        return false;
    }

    public Set<ObservableValue<?>> dependencySet() {
        return Collections.emptySet();
    }

    public void whenEquals(final VALUE v, final Runnable action) {
        Objects.requireNonNull(action);
        ObservableListener l = new ObservableListener<VALUE>(){

            @Override
            public void onEvent(ObservableValue<VALUE> ov, EventType et) {
                assert (ov == ObservableValue.this);
                if (ov.equals(v)) {
                    action.run();
                    ObservableValue.this.removeListener(this);
                }
            }
        };
        this.addListener(l);
    }

    public int numListener() {
        return this.listenerRefs == null ? 0 : this.listenerRefs.size();
    }

    public ObservableListener<VALUE> addListener(ObservableListener<VALUE> l) {
        return this.addListener(l, () -> l);
    }

    public ObservableListener<VALUE> addWeakListener(ObservableListener<VALUE> l) {
        WeakReference<ObservableListener<VALUE>> weakRef = new WeakReference<ObservableListener<VALUE>>(l);
        return this.addListener(l, weakRef::get);
    }

    private ObservableListener<VALUE> addListener(ObservableListener<VALUE> l, Supplier<ObservableListener<VALUE>> e) {
        Objects.requireNonNull(l);
        this.initListenerList();
        this.supplierLookup.put(l, e);
        this.listenerRefs.add(e);
        return l;
    }

    public boolean removeListener(ObservableListener<VALUE> l) {
        Objects.requireNonNull(l);
        this.initListenerList();
        if (this.firingInProgress > 0) {
            boolean stillContains;
            if (this.removeWhileFiring == null) {
                this.removeWhileFiring = new ArrayList<ObservableListener<VALUE>>();
            }
            boolean bl = stillContains = this.supplierLookup.containsKey(l) && !this.removeWhileFiring.contains(l);
            if (stillContains) {
                this.removeWhileFiring.add(l);
            }
            return stillContains;
        }
        Supplier<ObservableListener<VALUE>> supp = this.supplierLookup.remove(l);
        if (supp != null) {
            this.listenerRefs.remove(supp);
        }
        return supp != null;
    }

    private void initListenerList() {
        if (this.listenerRefs == null) {
            this.listenerRefs = new ArrayList<Supplier<ObservableListener<VALUE>>>();
            this.supplierLookup = new WeakHashMap<ObservableListener<VALUE>, Supplier<ObservableListener<VALUE>>>();
        }
    }

    protected void fireEvent(EventType event) {
        ++this.firingInProgress;
        for (Supplier<ObservableListener<VALUE>> supplier : this.listenerRefs) {
            ObservableListener<VALUE> l = supplier.get();
            if (l == null) continue;
            l.onEvent(this, event);
        }
        if (--this.firingInProgress == 0 && this.removeWhileFiring != null) {
            for (ObservableListener observableListener : this.removeWhileFiring) {
                boolean removeRes = this.removeListener(observableListener);
                assert (removeRes);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        VALUE currentValue = this.get();
        if (obj instanceof ObservableValue) {
            ObservableValue other = (ObservableValue)obj;
            return Objects.equals(currentValue, other.get());
        }
        return Objects.equals(obj, currentValue);
    }

    public static enum EventType {
        VALUE_CHANGED,
        MIGHT_HAVE_CHANGED;

    }

    @FunctionalInterface
    public static interface ObservableListener<V> {
        public void onEvent(ObservableValue<V> var1, EventType var2);
    }
}

