/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.util.observer;

import jasima.core.util.TypeHint;
import jasima.core.util.observer.Notifier;
import jasima.core.util.observer.NotifierListener;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Objects;

public class NotifierImpl<SUBJECT extends Notifier<SUBJECT, MESSAGE>, MESSAGE>
implements Notifier<SUBJECT, MESSAGE> {
    private final SUBJECT subject;
    private ArrayList<NotifierListener<SUBJECT, MESSAGE>> listeners;
    private ArrayDeque<MESSAGE> msgs;
    private int it;
    private NotifierListener<SUBJECT, MESSAGE> current;

    public NotifierImpl(SUBJECT subject) {
        this.subject = subject;
        this.listeners = new ArrayList();
        this.msgs = null;
        this.it = -1;
        this.current = null;
    }

    @Override
    public Notifier<SUBJECT, MESSAGE> notifierImpl() {
        return this;
    }

    @Override
    public synchronized int numListener() {
        return this.listeners.size();
    }

    @Override
    public synchronized <T extends NotifierListener<SUBJECT, MESSAGE>> T addListener(T l) {
        this.listeners.add(Objects.requireNonNull(l));
        return l;
    }

    @Override
    public <T extends NotifierListener<SUBJECT, MESSAGE>> void addListener(Class<T> listenerType, T eventHandler) {
        this.addListener(eventHandler);
    }

    @Override
    public <T extends NotifierListener<SUBJECT, MESSAGE>> void addListener(TypeHint<T> listenerType, T eventHandler) {
        this.addListener(eventHandler);
    }

    @Override
    public synchronized boolean removeListener(NotifierListener<SUBJECT, MESSAGE> l) {
        int idx = this.listeners.indexOf(Objects.requireNonNull(l));
        if (idx < 0) {
            return false;
        }
        this.listeners.remove(idx);
        if (this.it >= 0 && this.it < idx) {
            --this.it;
            assert (this.it >= 0);
        }
        return true;
    }

    @Override
    public synchronized void removeCurrentListener() {
        boolean removeRes = this.removeListener(Objects.requireNonNull(this.current));
        assert (removeRes);
    }

    @Override
    public synchronized NotifierListener<SUBJECT, MESSAGE> getListener(int idx) {
        return this.listeners.get(idx);
    }

    @Override
    public synchronized void fire(MESSAGE msg) {
        if (this.it >= 0) {
            if (this.msgs == null) {
                this.msgs = new ArrayDeque();
            }
            this.msgs.addLast(msg);
        } else {
            try {
                do {
                    this.it = 0;
                    while (this.it < this.listeners.size()) {
                        NotifierListener<SUBJECT, MESSAGE> l = this.listeners.get(this.it);
                        ++this.it;
                        this.current = l;
                        l.inform(this.subject, msg);
                    }
                    this.it = -1;
                    msg = null;
                    if (this.msgs == null || this.msgs.size() <= 0) continue;
                    msg = this.msgs.removeFirst();
                } while (msg != null);
            }
            finally {
                this.current = null;
            }
        }
    }
}

