/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.util.observer;

import jasima.core.util.TypeHint;
import jasima.core.util.observer.NotifierImpl;
import jasima.core.util.observer.NotifierListener;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public interface Notifier<SUBJECT extends Notifier<SUBJECT, MESSAGE>, MESSAGE> {
    public static final Map<Notifier<?, ?>, NotifierImpl<?, ?>> adapters = new HashMap();

    default public int numListener() {
        return this.notifierImpl().numListener();
    }

    default public <T extends NotifierListener<SUBJECT, MESSAGE>> T addListener(T l) {
        return this.notifierImpl().addListener(l);
    }

    default public <T extends NotifierListener<SUBJECT, MESSAGE>> void addListener(Class<T> eventType, T eventHandler) {
        this.notifierImpl().addListener(eventType, eventHandler);
    }

    default public <T extends NotifierListener<SUBJECT, MESSAGE>> void addListener(TypeHint<T> eventType, T eventHandler) {
        this.notifierImpl().addListener(eventType, eventHandler);
    }

    default public void removeCurrentListener() {
        this.notifierImpl().removeCurrentListener();
    }

    default public boolean removeListener(NotifierListener<SUBJECT, MESSAGE> l) {
        return this.notifierImpl().removeListener(l);
    }

    default public NotifierListener<SUBJECT, MESSAGE> getListener(int idx) {
        return this.notifierImpl().getListener(idx);
    }

    default public void fire(MESSAGE msg) {
        this.notifierImpl().fire(msg);
    }

    default public <T extends NotifierListener<SUBJECT, MESSAGE>> void fire(TypeHint<T> hint, Consumer<T> forwarder) {
        for (int i = 0; i < this.numListener(); ++i) {
            NotifierListener<SUBJECT, MESSAGE> l = this.getListener(i);
            forwarder.accept(l);
        }
    }

    default public Notifier<SUBJECT, MESSAGE> notifierImpl() {
        NotifierImpl<Object, Object> adapter = adapters.get(this);
        if (adapter == null) {
            adapter = new NotifierImpl(this);
            adapters.put(this, adapter);
        }
        return adapter;
    }
}

