/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.util.observer;

import jasima.core.util.observer.ObservableValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;

public class DerivedObservable<T>
extends ObservableValue<T> {
    private final Supplier<T> expression;
    private Set<ObservableValue<?>> dependencies;
    private boolean isStale;
    private final ObservableValue.ObservableListener depChangeListener;
    private boolean listenerInstalled;

    public DerivedObservable(Supplier<T> expression, ObservableValue<?> ... dependencies) {
        this.expression = expression;
        this.dependencies = new HashSet(Arrays.asList(dependencies));
        this.depChangeListener = this::onDependencyChanged;
        this.isStale = true;
        this.listenerInstalled = false;
    }

    @Override
    public T get() {
        if (!this.listenerInstalled) {
            this.installListener();
        }
        if (this.isStale) {
            this.update();
        }
        return (T)super.get();
    }

    @Override
    public void set(T newValue) {
        throw new UnsupportedOperationException("Can't explicitly set the value of a derived observable.");
    }

    public void invalidate() {
        if (!this.isStale) {
            this.isStale = true;
            if (this.numListener() > 0) {
                this.fireEvent(ObservableValue.EventType.MIGHT_HAVE_CHANGED);
            }
        }
    }

    public T update() {
        T v = this.expression.get();
        this.internalSet(v);
        this.isStale = false;
        return v;
    }

    @Override
    public boolean isStale() {
        return this.isStale;
    }

    @Override
    public Set<ObservableValue<?>> dependencySet() {
        return Collections.unmodifiableSet(this.dependencies);
    }

    private void installListener() {
        for (ObservableValue<?> v : this.dependencies) {
            v.addWeakListener(this.depChangeListener);
        }
        this.listenerInstalled = true;
    }

    private void onDependencyChanged(Object sender, Object event) {
        assert (ObservableValue.EventType.VALUE_CHANGED.equals(event) || ObservableValue.EventType.MIGHT_HAVE_CHANGED.equals(event));
        this.invalidate();
    }
}

