/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.util.i18n;

import jasima.core.JasimaExtension;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;

public final class I18n {
    public static final Locale DEF_LOCALE = Locale.UK;
    private static final Locale UNKNOWN_LOCALE = Locale.forLanguageTag("yq-YQ");
    private static final Set<String> bundleNames = new HashSet<String>();
    private static final Map<Locale, ArrayDeque<ResourceBundle>> loadedBundles = new HashMap<Locale, ArrayDeque<ResourceBundle>>();

    public static String defFormat(String formatString, Object ... args) {
        return String.format(DEF_LOCALE, formatString, args);
    }

    public static String message(Enum<?> key) {
        return I18n.message(DEF_LOCALE, key);
    }

    public static String message(String keyName) {
        return I18n.message(DEF_LOCALE, keyName);
    }

    public static String message(Locale l, Enum<?> key) {
        return I18n.message(l, I18n.keyName(key));
    }

    public static String message(Locale l, String keyName) {
        ArrayDeque bundles = loadedBundles.computeIfAbsent(l, I18n::loadNewLocale);
        Optional<String> firstMatchingMsg = bundles.stream().map(rb -> I18n.bundleLookup(rb, keyName)).filter(Objects::nonNull).findFirst();
        return firstMatchingMsg.orElseThrow(() -> new MissingResourceException(I18n.formattedMessage(I18nConsts.RES_NOT_FOUND, keyName), I18n.class.getName(), keyName));
    }

    public static String formattedMessage(Enum<?> key, Object ... args) {
        return I18n.formattedMessage(DEF_LOCALE, key, args);
    }

    public static String formattedMessage(String keyName, Object ... args) {
        return I18n.formattedMessage(DEF_LOCALE, keyName, args);
    }

    public static String formattedMessage(Locale l, Enum<?> key, Object ... args) {
        return I18n.formattedMessage(l, I18n.message(l, key), args);
    }

    public static String formattedMessage(Locale l, String keyName, Object ... args) {
        return String.format(l, I18n.message(l, keyName), args);
    }

    public static String keyName(Enum<?> key) {
        return key.getClass().getCanonicalName() + "." + key.toString();
    }

    public static void registerResourceBundle(String name) {
        if (bundleNames.contains(Objects.requireNonNull(name))) {
            return;
        }
        loadedBundles.forEach((l, rbs) -> rbs.addFirst(I18n.loadBundle(name, l)));
        bundleNames.add(name);
    }

    @SafeVarargs
    public static <E extends Enum<E>> void requireResourceBundle(String bundleName, Class<E> ... enumTypes) {
        I18n.registerResourceBundle(bundleName);
        for (Class<E> et : enumTypes) {
            I18n.checkEnumTypeHasDefaultMessages(et);
        }
    }

    public static <E extends Enum<E>> void checkEnumTypeHasDefaultMessages(Class<E> enumType) {
        for (Enum e : (Enum[])enumType.getEnumConstants()) {
            I18n.message(UNKNOWN_LOCALE, e);
        }
    }

    private static String bundleLookup(ResourceBundle rb, String keyName) {
        try {
            return rb.getString(keyName);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static ArrayDeque<ResourceBundle> loadNewLocale(Locale l) {
        return bundleNames.stream().map(n -> I18n.loadBundle(n, l)).collect(Collectors.toCollection(ArrayDeque::new));
    }

    private static ResourceBundle loadBundle(String name, Locale l) {
        return ResourceBundle.getBundle(name, l, ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_DEFAULT));
    }

    static {
        JasimaExtension.requireExtensionsLoaded();
        loadedBundles.put(DEF_LOCALE, I18n.loadNewLocale(DEF_LOCALE));
        I18n.requireResourceBundle("jasima.core.util.i18n.Messages", I18nConsts.class);
    }

    static enum I18nConsts {
        RES_NOT_FOUND;

    }
}

