/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.util.converter;

import jasima.core.util.converter.ArgListTokenizer;
import jasima.core.util.converter.TypeToStringConverter;
import java.awt.List;
import java.lang.reflect.Array;
import java.util.ArrayList;

public class TypeToStringConverterGenericList
extends TypeToStringConverter {
    @Override
    public Class<?>[] handledTypes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T fromString(ArgListTokenizer tk, Class<T> requiredType, String context, ClassLoader loader, String[] packageSearchPath) {
        Object resObj;
        ArgListTokenizer.TokenType t;
        boolean isList = List.class.isAssignableFrom(requiredType);
        assert (requiredType.isArray() || isList);
        Class componentType = List.class.isAssignableFrom(requiredType) ? Object.class : requiredType.getComponentType();
        TypeToStringConverter elementConverter = TypeToStringConverterGenericList.lookupConverter(componentType);
        ArrayList<Object> res = new ArrayList<Object>();
        tk.assureTokenTypes(tk.nextTokenNoWhitespace(), ArgListTokenizer.TokenType.BRACKETS_OPEN);
        while ((t = tk.nextTokenNoWhitespace()) != ArgListTokenizer.TokenType.BRACKETS_CLOSE) {
            tk.pushBackToken();
            Object element = elementConverter.fromString(tk, componentType, context, loader, packageSearchPath);
            res.add(element);
            ArgListTokenizer.TokenType t2 = tk.nextTokenNoWhitespace();
            tk.assureTokenTypes(t2, ArgListTokenizer.TokenType.BRACKETS_CLOSE, ArgListTokenizer.TokenType.SEMICOLON);
            if (t2 != ArgListTokenizer.TokenType.BRACKETS_CLOSE) continue;
            tk.pushBackToken();
        }
        if (isList) {
            resObj = List.class.cast(res);
        } else {
            Object[] listAsArray = res.toArray((Object[])Array.newInstance(componentType, res.size()));
            resObj = listAsArray;
        }
        return resObj;
    }
}

