/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.util.converter;

import jasima.core.JasimaExtension;
import jasima.core.util.TypeUtil;
import jasima.core.util.converter.ArgListTokenizer;
import jasima.core.util.converter.TypeToStringConverterGenericList;
import jasima.core.util.i18n.I18n;
import java.awt.List;
import java.util.HashMap;

public abstract class TypeToStringConverter {
    private static HashMap<Class<?>, TypeToStringConverter> converterReg = new HashMap();

    public abstract Class<?>[] handledTypes();

    public abstract <T> T fromString(ArgListTokenizer var1, Class<T> var2, String var3, ClassLoader var4, String[] var5);

    public String toString(Object o) {
        return String.valueOf(o);
    }

    public static void registerConverter(TypeToStringConverter fact) {
        for (Class<?> handledType : fact.handledTypes()) {
            converterReg.put(handledType, fact);
        }
    }

    public static String convertToString(Object o) {
        TypeToStringConverter conv = TypeToStringConverter.lookupConverter(o.getClass());
        return conv.toString(o);
    }

    public static <T> T convertFromString(String s, Class<T> requiredType, String context, ClassLoader loader, String[] packageSearchPath) {
        ArgListTokenizer tk = new ArgListTokenizer(s);
        T value = TypeToStringConverter.convertFromString(tk, requiredType, context, loader, packageSearchPath);
        if (tk.nextToken() != null) {
            throw new TypeUtil.TypeConversionException(I18n.defFormat("Can't create object for value '%s' (property path: '%s'): There is data after the last token: '%s'.", s, context, s.substring(tk.currTokenStart())));
        }
        return value;
    }

    public static <T> T convertFromString(ArgListTokenizer tk, Class<T> requiredType, String context, ClassLoader loader, String[] packageSearchPath) {
        TypeToStringConverter conv = TypeToStringConverter.lookupConverter(requiredType);
        return conv.fromString(tk, requiredType, context, loader, packageSearchPath);
    }

    public static TypeToStringConverter lookupConverter(Class<?> requiredType) {
        if (requiredType.isArray() || List.class.isAssignableFrom(requiredType)) {
            return new TypeToStringConverterGenericList();
        }
        TypeToStringConverter res = converterReg.get(requiredType);
        if (res == null) {
            Class<?> c;
            Class<?>[] classArray = TypeUtil.computeClasses(requiredType);
            int n = classArray.length;
            for (int i = 0; i < n && (res = converterReg.get(c = classArray[i])) == null; ++i) {
            }
        }
        assert (res != null);
        return res;
    }

    static {
        JasimaExtension.requireExtensionsLoaded();
    }
}

