/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.util.converter;

import com.thoughtworks.xstream.XStreamException;
import jasima.core.util.FileFormat;
import jasima.core.util.TypeUtil;
import jasima.core.util.XmlUtil;
import jasima.core.util.converter.ArgListTokenizer;
import jasima.core.util.converter.TypeToStringConverter;
import jasima.core.util.i18n.I18n;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Map;

public class TypeConverterJavaBean
extends TypeToStringConverter {
    public static final String NULL = "@null";

    @Override
    public Class<?>[] handledTypes() {
        return new Class[]{Object.class};
    }

    @Override
    public <T> T fromString(ArgListTokenizer tk, Class<T> requiredType, String context, ClassLoader loader, String[] packageSearchPath) throws TypeUtil.TypeConversionException {
        ArgListTokenizer.TokenType token;
        T root;
        tk.assureTokenTypes(tk.nextTokenNoWhitespace(), ArgListTokenizer.TokenType.STRING);
        String className = tk.currTokenText();
        try {
            root = TypeConverterJavaBean.loadClassOrXml(className, requiredType, loader, packageSearchPath);
        }
        catch (FileReadException | NoTypeFoundException | ReflectiveOperationException e) {
            throw new TypeUtil.TypeConversionException(I18n.defFormat("Can't create object for value '%s' (property path: '%s'): %s", className, context, TypeConverterJavaBean.exceptionMessage(e)), e);
        }
        if (tk.nextTokenNoWhitespace() != ArgListTokenizer.TokenType.PARENS_OPEN) {
            tk.pushBackToken();
            return root;
        }
        Map<String, PropertyDescriptor> beanProps = TypeUtil.writableProperties(root.getClass());
        do {
            token = tk.nextTokenNoWhitespace();
            tk.assureTokenTypes(token, ArgListTokenizer.TokenType.STRING, ArgListTokenizer.TokenType.PARENS_CLOSE);
            if (token == ArgListTokenizer.TokenType.PARENS_CLOSE) break;
            String propName = tk.currTokenText();
            tk.assureTokenTypes(tk.nextTokenNoWhitespace(), ArgListTokenizer.TokenType.EQUALS);
            PropertyDescriptor prop = beanProps.get(propName.toLowerCase(I18n.DEF_LOCALE));
            if (prop == null) {
                throw new RuntimeException(I18n.defFormat("Can't find property '%s' in type '%s', property path: '%s'", propName, root.getClass().getName(), context));
            }
            try {
                String propPath = context != null && context.length() > 0 ? context + "." + propName : propName;
                Object value = TypeConverterJavaBean.convertFromString(tk, prop.getPropertyType(), propPath, loader, packageSearchPath);
                prop.getWriteMethod().invoke(root, value);
            }
            catch (TypeUtil.TypeConversionException | ReflectiveOperationException e1) {
                throw new TypeUtil.TypeConversionException(I18n.defFormat("Can't set property '%s' in type %s (property path: '%s'): %s", propName, root.getClass().getName(), context, TypeConverterJavaBean.exceptionMessage(e1)), e1);
            }
            token = tk.nextTokenNoWhitespace();
            tk.assureTokenTypes(token, ArgListTokenizer.TokenType.SEMICOLON, ArgListTokenizer.TokenType.PARENS_CLOSE);
        } while (token == ArgListTokenizer.TokenType.SEMICOLON || token != ArgListTokenizer.TokenType.PARENS_CLOSE);
        return root;
    }

    private static <T> T loadClassOrXml(String asString, Class<T> requiredType, ClassLoader l, String[] packageSearchPath) throws ReflectiveOperationException, FileReadException, NoTypeFoundException {
        if (NULL.equalsIgnoreCase(asString)) {
            return null;
        }
        try {
            T o = requiredType.cast(TypeConverterJavaBean.searchAndInstanciateClass(asString, l, packageSearchPath));
            if (o != null) {
                return o;
            }
            o = requiredType.cast(TypeConverterJavaBean.loadXmlFile(asString));
            if (o != null) {
                return o;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        throw new NoTypeFoundException(I18n.defFormat("Can't load/convert '%s', required type: %s", asString, requiredType));
    }

    private static Object searchAndInstanciateClass(String className, ClassLoader l, String[] searchPath) throws ReflectiveOperationException, IllegalAccessException {
        Class<?> klazz = null;
        try {
            klazz = l.loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (klazz == null) {
            for (String packageName : searchPath) {
                try {
                    klazz = l.loadClass(packageName + "." + className);
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        if (klazz != null) {
            if (Modifier.isAbstract(klazz.getModifiers())) {
                throw new InstantiationException("Can't instantiate an abstract class.");
            }
            return klazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return null;
    }

    private static Object loadXmlFile(String fileName) throws FileReadException {
        File f = new File(fileName);
        if (!f.canRead() || f.isDirectory()) {
            return null;
        }
        try {
            return XmlUtil.loadXML(FileFormat.JASIMA_BEAN, f);
        }
        catch (XStreamException x) {
            throw new FileReadException(fileName, x);
        }
    }

    @Override
    public String toString(Object o) {
        if (o == null) {
            return NULL;
        }
        Map<String, PropertyDescriptor> props = TypeUtil.writableProperties(o.getClass());
        if (!props.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append(o.getClass().getName());
            sb.append('(');
            for (PropertyDescriptor p : props.values()) {
                String name = p.getName();
                Object value = TypeUtil.getPropertyValue(o, name);
                sb.append(name).append('=').append(TypeConverterJavaBean.convertToString(value));
                sb.append(';');
            }
            if (props.size() != 0) {
                sb.setCharAt(sb.length() - 1, ')');
            } else {
                sb.append(')');
            }
            return sb.toString();
        }
        return o.toString();
    }

    public static String exceptionMessage(Throwable t) {
        String msg = t.getMessage();
        if (t instanceof InvocationTargetException) {
            msg = I18n.defFormat("Error invoking method or constructor: %s", t.getCause().toString());
        } else if (t instanceof NoSuchMethodException) {
            msg = I18n.defFormat("Method or constructor not found: %s", t.getMessage());
        } else if (t instanceof FileReadException) {
            FileReadException e = (FileReadException)t;
            msg = I18n.defFormat("Error reading file '%s': %s", e.getFileName(), e.getCause().getMessage());
        }
        return msg;
    }

    private static class NoTypeFoundException
    extends Exception {
        private static final long serialVersionUID = -7271169253051939902L;

        public NoTypeFoundException(String msg) {
            super(msg);
        }
    }

    private static class FileReadException
    extends Exception {
        private static final long serialVersionUID = -1763832991537196846L;
        private final String fileName;

        public FileReadException(String fileName, Throwable cause) {
            super(null, cause);
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

