/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.util.converter;

import jasima.core.random.continuous.DblSequence;
import jasima.core.util.converter.ArgListTokenizer;
import jasima.core.util.converter.TypeToStringConverter;
import jasima.core.util.i18n.I18n;
import java.util.HashMap;

public class TypeConverterDblStream
extends TypeToStringConverter {
    private static HashMap<String, StreamFactory> streamFactoryReg = new HashMap();

    @Override
    public Class<?>[] handledTypes() {
        return new Class[]{DblSequence.class};
    }

    @Override
    public <T> T fromString(ArgListTokenizer tk, Class<T> requiredType, String context, ClassLoader loader, String[] packageSearchPath) throws ClassCastException {
        tk.assureTokenTypes(tk.nextTokenNoWhitespace(), ArgListTokenizer.TokenType.STRING);
        String prefix = tk.currTokenText().trim().toLowerCase(I18n.DEF_LOCALE);
        StreamFactory fact = TypeConverterDblStream.lookupFactory(prefix);
        DblSequence stream = fact.stringToStream(tk);
        return requiredType.cast(stream);
    }

    @Override
    public String toString(Object o) {
        DblSequence s = (DblSequence)o;
        StreamFactory fact = TypeConverterDblStream.lookupFactory(s.getClass().getName());
        return fact.streamToString(s);
    }

    public static void registerStreamFactory(StreamFactory fact) {
        for (String s : fact.getTypePrefixes()) {
            streamFactoryReg.put(s, fact);
        }
    }

    public static StreamFactory lookupFactory(String prefix) {
        return streamFactoryReg.get(prefix);
    }

    static {
        TypeConverterDblStream.registerConverter(new TypeConverterDblStream());
    }

    public static interface StreamFactory {
        public String[] getTypePrefixes();

        public DblSequence stringToStream(ArgListTokenizer var1);

        public String streamToString(DblSequence var1);
    }
}

