/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.util.converter;

import jasima.core.util.TypeUtil;
import jasima.core.util.converter.ArgListTokenizer;
import jasima.core.util.converter.TypeToStringConverter;
import jasima.core.util.i18n.I18n;

public class TypeConverterBasicTypes
extends TypeToStringConverter {
    @Override
    public Class<?>[] handledTypes() {
        return new Class[]{Integer.TYPE, Integer.class, Long.TYPE, Long.class, Double.TYPE, Double.class, Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Float.TYPE, Float.class, Character.TYPE, Character.class, Enum.class, String.class};
    }

    @Override
    public <T> T fromString(ArgListTokenizer tk, Class<T> klass, String context, ClassLoader loader, String[] packageSearchPath) throws NumberFormatException, TypeUtil.TypeConversionException {
        tk.assureTokenTypes(tk.nextTokenNoWhitespace(), ArgListTokenizer.TokenType.STRING);
        String s = tk.currTokenText();
        if (klass == String.class) {
            return (T)s;
        }
        if (klass == Integer.TYPE || klass == Integer.class) {
            return (T)Integer.valueOf(s);
        }
        if (klass == Long.TYPE || klass == Long.class) {
            return (T)Long.valueOf(s);
        }
        if (klass == Double.TYPE || klass == Double.class) {
            return (T)Double.valueOf(s);
        }
        if (klass == Boolean.TYPE || klass == Boolean.class) {
            if (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("yes") || s.equalsIgnoreCase("1")) {
                return (T)Boolean.TRUE;
            }
            if (s.equalsIgnoreCase("false") || s.equalsIgnoreCase("no") || s.equalsIgnoreCase("0")) {
                return (T)Boolean.FALSE;
            }
            throw new TypeUtil.TypeConversionException(I18n.defFormat("Can't convert '%s' to bool.", s));
        }
        if (klass.isEnum()) {
            return (T)Enum.valueOf(klass.asSubclass(Enum.class), s);
        }
        if (klass == Byte.TYPE || klass == Byte.class) {
            return (T)Byte.valueOf(s);
        }
        if (klass == Short.TYPE || klass == Short.class) {
            return (T)Short.valueOf(s);
        }
        if (klass == Float.TYPE || klass == Float.class) {
            return (T)Float.valueOf(s);
        }
        if ((klass == Character.TYPE || klass == Character.class) && s.length() == 1) {
            return (T)Character.valueOf(s.charAt(0));
        }
        throw new AssertionError();
    }
}

