/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.util.converter;

import jasima.core.random.continuous.DblSequence;
import jasima.core.random.discrete.IntConst;
import jasima.core.util.Util;
import jasima.core.util.converter.ArgListTokenizer;
import jasima.core.util.converter.TypeConverterDblStream;
import jasima.core.util.converter.TypeToStringConverter;
import java.util.ArrayList;

public class IntConstFactory
implements TypeConverterDblStream.StreamFactory {
    private static final String[] PREFIXES = new String[]{"intConst", IntConst.class.getName()};

    @Override
    public String[] getTypePrefixes() {
        return PREFIXES;
    }

    @Override
    public DblSequence stringToStream(ArgListTokenizer tk) {
        TypeToStringConverter intConv = TypeToStringConverter.lookupConverter(Integer.TYPE);
        assert (intConv != null);
        String prefix = tk.currTokenText();
        tk.assureTokenTypes(tk.nextTokenNoWhitespace(), ArgListTokenizer.TokenType.PARENS_OPEN);
        ArrayList<Integer> values = new ArrayList<Integer>();
        Integer d = intConv.fromString(tk, Integer.class, prefix, this.getClass().getClassLoader(), Util.DEF_CLASS_SEARCH_PATH);
        values.add(d);
        tk.assureTokenTypes(tk.nextTokenNoWhitespace(), ArgListTokenizer.TokenType.SEMICOLON, ArgListTokenizer.TokenType.PARENS_CLOSE);
        while (tk.currTokenType() != ArgListTokenizer.TokenType.PARENS_CLOSE) {
            Integer i2 = intConv.fromString(tk, Integer.class, prefix, this.getClass().getClassLoader(), Util.DEF_CLASS_SEARCH_PATH);
            values.add(i2);
            tk.assureTokenTypes(tk.nextTokenNoWhitespace(), ArgListTokenizer.TokenType.SEMICOLON, ArgListTokenizer.TokenType.PARENS_CLOSE);
        }
        int[] vs = new int[values.size()];
        for (int i = 0; i < vs.length; ++i) {
            vs[i] = (Integer)values.get(i);
        }
        IntConst intConst = new IntConst();
        intConst.setValues(vs);
        return intConst;
    }

    @Override
    public String streamToString(DblSequence s) {
        TypeToStringConverter doubleConv = TypeToStringConverter.lookupConverter(Integer.class);
        assert (doubleConv != null);
        IntConst dblConst = (IntConst)s;
        StringBuilder sb = new StringBuilder();
        sb.append(PREFIXES[0]).append('(');
        int[] nArray = dblConst.getValues();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            double d = nArray[i];
            sb.append(doubleConv.toString(d)).append(';');
        }
        sb.setCharAt(sb.length() - 1, ')');
        return sb.toString();
    }
}

