/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.util.converter;

import jasima.core.random.continuous.DblDistribution;
import jasima.core.random.continuous.DblSequence;
import jasima.core.util.Util;
import jasima.core.util.converter.ArgListTokenizer;
import jasima.core.util.converter.TypeConverterDblStream;
import jasima.core.util.converter.TypeToStringConverter;
import java.util.ArrayList;
import org.apache.commons.math3.distribution.ExponentialDistribution;
import org.apache.commons.math3.distribution.RealDistribution;

public class DblDistributionFactory
implements TypeConverterDblStream.StreamFactory {
    private static final String[] PREFIXES = new String[]{"dblExp", DblDistribution.class.getName()};

    @Override
    public String[] getTypePrefixes() {
        return PREFIXES;
    }

    @Override
    public DblSequence stringToStream(ArgListTokenizer tk) {
        TypeToStringConverter doubleConv = TypeToStringConverter.lookupConverter(Double.class);
        assert (doubleConv != null);
        String prefix = tk.currTokenText();
        tk.assureTokenTypes(tk.nextTokenNoWhitespace(), ArgListTokenizer.TokenType.PARENS_OPEN);
        ArrayList<Double> values = new ArrayList<Double>();
        Double v1 = doubleConv.fromString(tk, Double.class, prefix, this.getClass().getClassLoader(), Util.DEF_CLASS_SEARCH_PATH);
        values.add(v1);
        tk.assureTokenTypes(tk.nextTokenNoWhitespace(), ArgListTokenizer.TokenType.PARENS_CLOSE);
        return new DblDistribution((RealDistribution)new ExponentialDistribution(v1.doubleValue()));
    }

    @Override
    public String streamToString(DblSequence s) {
        DblDistribution dist = (DblDistribution)s;
        assert (dist.getDistribution() instanceof ExponentialDistribution);
        TypeToStringConverter doubleConv = TypeToStringConverter.lookupConverter(Double.class);
        assert (doubleConv != null);
        StringBuilder sb = new StringBuilder();
        sb.append(PREFIXES[0]).append('(');
        double v = ((ExponentialDistribution)dist.getDistribution()).getMean();
        sb.append(doubleConv.toString(v));
        sb.setCharAt(sb.length() - 1, ')');
        return sb.toString();
    }
}

