/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.util.converter;

import jasima.core.random.continuous.DblConst;
import jasima.core.random.continuous.DblSequence;
import jasima.core.util.Util;
import jasima.core.util.converter.ArgListTokenizer;
import jasima.core.util.converter.TypeConverterDblStream;
import jasima.core.util.converter.TypeToStringConverter;
import java.util.ArrayList;

public class DblConstFactory
implements TypeConverterDblStream.StreamFactory {
    private static final String[] PREFIXES = new String[]{"const", "dblConst", DblConst.class.getName()};

    @Override
    public String[] getTypePrefixes() {
        return PREFIXES;
    }

    @Override
    public DblSequence stringToStream(ArgListTokenizer tk) {
        TypeToStringConverter doubleConv = TypeToStringConverter.lookupConverter(Double.class);
        assert (doubleConv != null);
        String prefix = tk.currTokenText();
        tk.assureTokenTypes(tk.nextTokenNoWhitespace(), ArgListTokenizer.TokenType.PARENS_OPEN);
        ArrayList<Double> values = new ArrayList<Double>();
        Double d = doubleConv.fromString(tk, Double.class, prefix, this.getClass().getClassLoader(), Util.DEF_CLASS_SEARCH_PATH);
        values.add(d);
        tk.assureTokenTypes(tk.nextTokenNoWhitespace(), ArgListTokenizer.TokenType.SEMICOLON, ArgListTokenizer.TokenType.PARENS_CLOSE);
        while (tk.currTokenType() != ArgListTokenizer.TokenType.PARENS_CLOSE) {
            Double d2 = doubleConv.fromString(tk, Double.class, prefix, this.getClass().getClassLoader(), Util.DEF_CLASS_SEARCH_PATH);
            values.add(d2);
            tk.assureTokenTypes(tk.nextTokenNoWhitespace(), ArgListTokenizer.TokenType.SEMICOLON, ArgListTokenizer.TokenType.PARENS_CLOSE);
        }
        double[] vs = new double[values.size()];
        for (int i = 0; i < vs.length; ++i) {
            vs[i] = (Double)values.get(i);
        }
        DblConst dblConst = new DblConst();
        dblConst.setValues(vs);
        return dblConst;
    }

    @Override
    public String streamToString(DblSequence s) {
        TypeToStringConverter doubleConv = TypeToStringConverter.lookupConverter(Double.class);
        assert (doubleConv != null);
        DblConst dblConst = (DblConst)s;
        StringBuilder sb = new StringBuilder();
        sb.append(PREFIXES[0]).append('(');
        for (double d : dblConst.getValues()) {
            sb.append(doubleConv.toString(d)).append(';');
        }
        sb.setCharAt(sb.length() - 1, ')');
        return sb.toString();
    }
}

