/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.util.converter;

import jasima.core.util.i18n.I18n;
import java.util.Arrays;
import java.util.Objects;

public class ArgListTokenizer {
    private static String ESCAPE_CHARS = "()[]=;rnt \\\"";
    private static String CHARS_TO_ESCAPE = "()[]=;\r\n\t \\\"";
    private String input;
    private int currPos;
    private int tokenStart;
    private int tokenEnd;
    private TokenType tokenType;
    private boolean tokenContainsEscapedChars;

    public ArgListTokenizer() {
        this(null);
    }

    public ArgListTokenizer(String input) {
        this.reset();
        this.input = input;
    }

    protected void reset() {
        this.currPos = 0;
        this.tokenEnd = -1;
        this.tokenStart = -1;
        this.tokenType = null;
        this.tokenContainsEscapedChars = false;
    }

    public TokenType nextTokenNoWhitespace() {
        TokenType t;
        while ((t = this.nextToken()) == TokenType.WHITE_SPACE) {
        }
        return t;
    }

    public TokenType nextToken() {
        this.tokenStart = this.currPos;
        this.tokenContainsEscapedChars = false;
        if (this.currPos >= this.input.length()) {
            this.tokenEnd = this.tokenStart = this.currPos++;
            this.tokenType = null;
            return null;
        }
        char c = this.input.charAt(this.currPos);
        ++this.currPos;
        this.tokenEnd = this.currPos;
        block0 : switch (c) {
            case '=': {
                this.tokenType = TokenType.EQUALS;
                break;
            }
            case '(': {
                this.tokenType = TokenType.PARENS_OPEN;
                break;
            }
            case ')': {
                this.tokenType = TokenType.PARENS_CLOSE;
                break;
            }
            case '[': {
                this.tokenType = TokenType.BRACKETS_OPEN;
                break;
            }
            case ']': {
                this.tokenType = TokenType.BRACKETS_CLOSE;
                break;
            }
            case ';': {
                this.tokenType = TokenType.SEMICOLON;
                break;
            }
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                this.tokenType = TokenType.WHITE_SPACE;
                while (this.currPos < this.input.length()) {
                    switch (this.input.charAt(this.currPos)) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            break;
                        }
                        default: {
                            this.tokenEnd = this.currPos;
                            break block0;
                        }
                    }
                    ++this.currPos;
                }
                break;
            }
            default: {
                this.tokenType = TokenType.STRING;
                this.readStringToken(c);
            }
        }
        return this.tokenType;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void readStringToken(char firstChar) {
        boolean isQuoted = false;
        if (firstChar == '\"') {
            isQuoted = true;
        }
        boolean escape = firstChar == '\\';
        char c = '\u0000';
        block8: while (this.currPos < this.input.length()) {
            c = this.input.charAt(this.currPos);
            if (escape) {
                c = '\u0000';
                escape = false;
                this.tokenContainsEscapedChars = true;
            }
            if (isQuoted) {
                switch (c) {
                    case '\\': {
                        escape = true;
                        break;
                    }
                    case '\"': {
                        break block8;
                    }
                }
            } else {
                switch (c) {
                    case '\\': {
                        escape = true;
                        break;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': 
                    case '\"': 
                    case '(': 
                    case ')': 
                    case ';': 
                    case '=': 
                    case '[': 
                    case ']': {
                        break block8;
                    }
                }
            }
            ++this.currPos;
        }
        if (escape) {
            throw new ParseException(this.tokenStart, "escape character at end of input '%s'", this.input);
        }
        if (isQuoted) {
            if (c != '\"') {
                throw new ParseException(this.tokenStart, "quoted string not closed in input '%s'", this.input);
            }
            ++this.currPos;
        }
        this.tokenEnd = this.currPos;
    }

    public String currTokenText() {
        if (this.currPos == this.tokenStart) {
            throw new IllegalStateException();
        }
        if (this.tokenType == null) {
            return null;
        }
        int start = this.tokenStart;
        int end = this.tokenEnd;
        if (this.input.charAt(start) == '\"') {
            assert (this.tokenType == TokenType.STRING);
            assert (this.input.charAt(end - 1) == '\"');
            assert (++start <= --end);
        }
        if (this.tokenContainsEscapedChars) {
            boolean escape = false;
            StringBuilder sb = new StringBuilder(end - start);
            for (int i = start; i < end; ++i) {
                int c = this.input.charAt(i);
                if (escape) {
                    if (ESCAPE_CHARS.indexOf(c) < 0) {
                        throw new ParseException(i, "invalid escaped character in input '%s'", this.input);
                    }
                    if (c == 116) {
                        c = 9;
                    } else if (c == 114) {
                        c = 13;
                    } else if (c == 110) {
                        c = 10;
                    }
                    sb.append((char)c);
                    escape = false;
                    continue;
                }
                if (c != 92) {
                    sb.append((char)c);
                    continue;
                }
                escape = true;
            }
            return sb.toString();
        }
        return this.input.substring(start, end);
    }

    public TokenType currTokenType() {
        if (this.currPos == this.tokenStart) {
            throw new IllegalStateException();
        }
        return this.tokenType;
    }

    public int currTokenStart() {
        if (this.currPos == this.tokenStart) {
            throw new IllegalStateException();
        }
        return this.tokenStart;
    }

    public int currTokenEnd() {
        if (this.currPos == this.tokenStart) {
            throw new IllegalStateException();
        }
        return this.tokenEnd;
    }

    public void pushBackToken() {
        if (this.currPos == this.tokenStart) {
            throw new IllegalStateException();
        }
        this.currPos = this.tokenStart;
    }

    public void setInput(String input) {
        this.input = Objects.requireNonNull(input);
    }

    public void assureTokenTypes(TokenType actual, TokenType ... expected) throws ParseException {
        for (TokenType e : expected) {
            if (actual != e) continue;
            return;
        }
        String msg = "expected one of: %s, but found: %s, '%s'";
        if (expected.length == 1) {
            msg = "expected %s, but found: %s, '%s'";
        }
        throw new ParseException(this.currTokenStart(), msg, new Object[]{Arrays.deepToString((Object[])expected), actual, this.currTokenText()});
    }

    public static String escapeString(String raw) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < raw.length(); ++i) {
            char c = raw.charAt(i);
            if (CHARS_TO_ESCAPE.indexOf(c) >= 0) {
                sb.append('\\');
                if (c == '\t') {
                    sb.append('t');
                    continue;
                }
                if (c == '\r') {
                    sb.append('r');
                    continue;
                }
                if (c == '\n') {
                    sb.append('n');
                    continue;
                }
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String quoteString(String raw) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < raw.length(); ++i) {
            char c = raw.charAt(i);
            if (CHARS_TO_ESCAPE.indexOf(c) >= 0 && "(); ".indexOf(c) < 0) {
                sb.append('\\');
                if (c == '\t') {
                    sb.append('t');
                    continue;
                }
                if (c == '\r') {
                    sb.append('r');
                    continue;
                }
                if (c == '\n') {
                    sb.append('n');
                    continue;
                }
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        return '\"' + sb.toString() + '\"';
    }

    public static class ParseException
    extends RuntimeException {
        private static final long serialVersionUID = 3473197915435659395L;
        private String msg;
        private Object[] msgParams;

        public ParseException(int errorPos, String msg, Object ... msgParams) {
            this.msg = msg;
            this.msgParams = new Object[1 + msgParams.length];
            this.msgParams[0] = errorPos + 1;
            for (int i = 0; i < msgParams.length; ++i) {
                this.msgParams[i + 1] = msgParams[i];
            }
        }

        @Override
        public String getMessage() {
            return I18n.defFormat("Parse error at or before position %d: " + this.msg, this.msgParams);
        }
    }

    public static enum TokenType {
        STRING,
        PARENS_OPEN,
        PARENS_CLOSE,
        BRACKETS_OPEN,
        BRACKETS_CLOSE,
        EQUALS,
        SEMICOLON,
        WHITE_SPACE;

    }
}

