/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.util.converter;

import jasima.core.util.converter.ArgListTokenizer;
import jasima.core.util.i18n.I18n;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public class ArgListParser {
    private final ArgListTokenizer tk;

    public ArgListParser(ArgListTokenizer tk) {
        this.tk = tk;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ParseTree parseClassAndPropDef() {
        ArgListTokenizer.TokenType token = this.tk.nextTokenNoWhitespace();
        this.assureTokenTypes(token, ArgListTokenizer.TokenType.STRING);
        String className = this.tk.currTokenText();
        LinkedHashMap<String, ParseTree> params = null;
        token = this.tk.nextTokenNoWhitespace();
        if (token == ArgListTokenizer.TokenType.PARENS_OPEN) {
            params = new LinkedHashMap<String, ParseTree>();
            do {
                token = this.tk.nextTokenNoWhitespace();
                this.assureTokenTypes(token, ArgListTokenizer.TokenType.STRING, ArgListTokenizer.TokenType.PARENS_CLOSE);
                if (token == ArgListTokenizer.TokenType.PARENS_CLOSE) return new ParseTree(className, params);
                String paramName = this.tk.currTokenText();
                this.assureTokenTypes(this.tk.nextTokenNoWhitespace(), ArgListTokenizer.TokenType.EQUALS);
                ParseTree paramValue = new ArgListParser(this.tk).parseClassAndPropDef();
                assert (paramValue != null);
                params.put(paramName, paramValue);
                token = this.tk.nextTokenNoWhitespace();
                this.assureTokenTypes(token, ArgListTokenizer.TokenType.SEMICOLON, ArgListTokenizer.TokenType.PARENS_CLOSE);
            } while (token == ArgListTokenizer.TokenType.SEMICOLON || token != ArgListTokenizer.TokenType.PARENS_CLOSE);
            return new ParseTree(className, params);
        } else {
            this.tk.pushBackToken();
        }
        return new ParseTree(className, params);
    }

    private void assureTokenTypes(ArgListTokenizer.TokenType actual, ArgListTokenizer.TokenType ... expected) {
        for (ArgListTokenizer.TokenType e : expected) {
            if (actual != e) continue;
            return;
        }
        String msg = "expected one of: %s, but found: %s, '%s'";
        if (expected.length == 1) {
            msg = "expected %s, but found: %s, '%s'";
        }
        throw new ArgListTokenizer.ParseException(this.tk.currTokenStart(), msg, new Object[]{Arrays.deepToString((Object[])expected), actual, this.tk.currTokenText()});
    }

    public static ParseTree parseClassAndPropDef(String input) throws ArgListTokenizer.ParseException {
        ArgListTokenizer tk = new ArgListTokenizer(input);
        ParseTree res = new ArgListParser(tk).parseClassAndPropDef();
        if (tk.nextToken() != null) {
            throw new ArgListTokenizer.ParseException(tk.currTokenStart(), I18n.defFormat("There is data after the last token: '%s'.", input.substring(tk.currTokenStart())), new Object[0]);
        }
        return res;
    }

    public static class ParseTree {
        private String classOrXmlName;
        private Map<String, ParseTree> params;

        public ParseTree(String classOrXmlName, Map<String, ParseTree> params) {
            this.classOrXmlName = classOrXmlName;
            this.params = params;
        }

        public String getClassOrXmlName() {
            return this.classOrXmlName;
        }

        public void setClassOrXmlName(String classOrXmlName) {
            this.classOrXmlName = classOrXmlName;
        }

        public Map<String, ParseTree> getParams() {
            return this.params;
        }

        public void setParams(Map<String, ParseTree> params) {
            this.params = params;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            ParseTree.toString(this, sb);
            return sb.toString();
        }

        public static StringBuilder toString(ParseTree t, StringBuilder sb) {
            sb.append(t.getClassOrXmlName());
            if (t.getParams() != null) {
                sb.append('(');
                for (Map.Entry<String, ParseTree> e : t.getParams().entrySet()) {
                    sb.append(e.getKey()).append('=');
                    ParseTree.toString(e.getValue(), sb);
                    sb.append(';');
                }
                if (t.getParams().entrySet().size() != 0) {
                    sb.setCharAt(sb.length() - 1, ')');
                } else {
                    sb.append(')');
                }
            }
            return sb;
        }
    }
}

