/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.util;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.security.AnyTypePermission;
import com.thoughtworks.xstream.security.NoTypePermission;
import jasima.core.experiment.Experiment;
import jasima.core.util.FileFormat;
import jasima.core.util.JasimaBeanConverter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class XmlUtil {
    private static final String JASIMA_BEAN_PREFIX = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<?jasima bean?>\n";
    private static final String XML_PREFIX = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>";

    public static Object loadXML(FileFormat format, String xmlString) {
        XStream xstream = XmlUtil.getXStream(format);
        Object o = xstream.fromXML(xmlString);
        return o;
    }

    public static Object loadXML(String xmlString) {
        return XmlUtil.loadXML(FileFormat.XSTREAM, xmlString);
    }

    public static Object loadXML(FileFormat format, File f) {
        XStream xstream = XmlUtil.getXStream(format);
        Object o = xstream.fromXML(f);
        return o;
    }

    public static Object loadXML(File f) {
        return XmlUtil.loadXML(FileFormat.JASIMA_BEAN, f);
    }

    public static Object loadXML(FileFormat format, Reader r) {
        XStream xstream = XmlUtil.getXStream(format);
        Object o = xstream.fromXML(r);
        return o;
    }

    public static Object loadXML(Reader r) {
        return XmlUtil.loadXML(FileFormat.JASIMA_BEAN, r);
    }

    public static String saveXML(FileFormat format, Object o) {
        XStream xstream = XmlUtil.getXStream(format);
        return xstream.toXML(o);
    }

    public static void saveXML(FileFormat format, Object o, Writer w) {
        XStream xstream = XmlUtil.getXStream(format);
        xstream.toXML(o, w);
    }

    public static void saveXML(FileFormat format, Object o, File f) {
        XStream xstream = XmlUtil.getXStream(format);
        try (BufferedWriter fw = new BufferedWriter(new FileWriter(f));){
            xstream.toXML(o, (Writer)fw);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void saveXML(Object o, File f) {
        XmlUtil.saveXML(FileFormat.XSTREAM, o, f);
    }

    public static void saveXML(Object o, Writer w) {
        XmlUtil.saveXML(FileFormat.XSTREAM, o, w);
    }

    public static String saveXML(Object o) {
        return XmlUtil.saveXML(FileFormat.XSTREAM, o);
    }

    private static XStream getXStream(final FileFormat format) {
        XStream xstream;
        if (format == FileFormat.JSON) {
            xstream = new XStream((HierarchicalStreamDriver)new JettisonMappedXmlDriver());
            xstream.registerConverter((Converter)new MapConverter(xstream.getMapper()));
        } else {
            xstream = new XStream((HierarchicalStreamDriver)new DomDriver(){

                public HierarchicalStreamWriter createWriter(Writer out) {
                    try {
                        switch (format) {
                            case JASIMA_BEAN: {
                                out.append(XmlUtil.JASIMA_BEAN_PREFIX);
                                break;
                            }
                            case XSTREAM: {
                                out.append(XmlUtil.XML_PREFIX);
                                break;
                            }
                        }
                        return super.createWriter(out);
                    }
                    catch (IOException e) {
                        throw new XStreamException((Throwable)e);
                    }
                }
            });
        }
        xstream.registerConverter((Converter)new MapConverter(xstream.getMapper()){

            public boolean canConvert(Class type) {
                if (type.equals(Experiment.UniqueNamesCheckingHashMap.class)) {
                    return true;
                }
                return super.canConvert(type);
            }
        });
        if (format == FileFormat.RESULTS_MAP) {
            xstream.setMode(1001);
        }
        if (format == FileFormat.JASIMA_BEAN) {
            xstream.registerConverter((Converter)new JasimaBeanConverter(xstream.getMapper(), true), -10);
        } else if (format == FileFormat.JSON) {
            xstream.registerConverter((Converter)new JasimaBeanConverter(xstream.getMapper(), false), -10);
        }
        xstream.addPermission(NoTypePermission.NONE);
        xstream.addPermission(AnyTypePermission.ANY);
        xstream.denyTypeHierarchy(ProcessBuilder.class);
        return xstream;
    }

    public static Object loadJSON(String jsonString) {
        return XmlUtil.loadXML(FileFormat.JSON, jsonString);
    }

    public static String saveJSON(Object o) {
        return XmlUtil.saveXML(FileFormat.JSON, o);
    }
}

