/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.util;

import java.util.Set;
import java.util.function.Function;

public interface ValueStore {
    default public <T> T valueStorePut(Object key, T value) {
        return this.valueStoreImpl().valueStorePut(key, value);
    }

    default public Object valueStoreGet(Object key) {
        return this.valueStoreImpl().valueStoreGet(key);
    }

    default public Object valueStoreGet(Object key, Object defaultValue) {
        Object value = this.valueStoreGet(key);
        return value != null ? value : defaultValue;
    }

    default public Object valueStoreUpdate(Object key, Function<Object, Object> func) {
        Object oldValue = this.valueStoreGet(key);
        Object newValue = func.apply(oldValue);
        if (newValue != null) {
            this.valueStorePut(key, newValue);
        } else {
            this.valueStoreRemove(key);
        }
        return newValue;
    }

    default public boolean valueStoreContains(Object key) {
        return this.valueStoreGet(key) != null;
    }

    default public int valueStoreGetNumKeys() {
        return this.valueStoreImpl().valueStoreGetNumKeys();
    }

    default public Set<Object> valueStoreGetAllKeys() {
        return this.valueStoreImpl().valueStoreGetAllKeys();
    }

    default public Object valueStoreRemove(Object key) {
        return this.valueStoreImpl().valueStoreRemove(key);
    }

    public ValueStore valueStoreImpl();

    public static boolean copy(ValueStore from, ValueStore to, String valueName) {
        if (!from.valueStoreContains(valueName)) {
            return false;
        }
        Object value = from.valueStoreGet(valueName);
        to.valueStorePut(valueName, value);
        return true;
    }
}

