/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.util;

import jasima.core.simulation.SimComponent;
import jasima.core.statistics.SummaryStat;
import jasima.core.util.i18n.I18n;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;

public class Util {
    private static final Properties buildProps = new Properties();
    public static final ExecutorService DEF_POOL;
    public static final String[] DEF_CLASS_SEARCH_PATH;

    public static String exceptionToString(@Nullable Throwable t) {
        if (t == null) {
            return "null";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        String s = ((Object)sw).toString();
        return s.replace(System.lineSeparator() + '\t', " \\\\ ").trim();
    }

    public static <T> T[] initializedArray(int numElements, Class<T> componentType) {
        T[] res = Util.newGenericArray(componentType, numElements);
        for (int i = 0; i < numElements; ++i) {
            res[i] = Util.create(componentType);
        }
        return res;
    }

    public static <T extends SimComponent> T[] initializedCompArray(int numElements, Class<T> componentType, String namePrefix) {
        SimComponent[] res = (SimComponent[])Util.newGenericArray(componentType, numElements);
        for (int i = 0; i < numElements; ++i) {
            res[i] = (SimComponent)Util.create(componentType);
            res[i].setName(namePrefix + (i + 1));
        }
        return res;
    }

    private static <T> T[] newGenericArray(Class<T> componentType, int n) {
        return (Object[])Array.newInstance(componentType, n);
    }

    private static <T> T create(Class<T> componentType) {
        try {
            return componentType.newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T[] removeFromArray(T[] a, T elementToRemove) {
        ArrayList<Object> l = new ArrayList<Object>(Arrays.asList(a));
        if (l.remove(elementToRemove)) {
            return l.toArray((Object[])Array.newInstance(a.getClass().getComponentType(), l.size()));
        }
        return a;
    }

    @SafeVarargs
    public static <T> T[] addToArray(T[] a, Class<T> compType, T ... newElement) {
        if (newElement == null || newElement.length == 0) {
            throw new IllegalArgumentException();
        }
        int newLength = newElement.length + (a == null ? 0 : a.length);
        ArrayList<T> l = new ArrayList<T>(newLength);
        if (a != null) {
            l.addAll(Arrays.asList(a));
        }
        for (T t : newElement) {
            l.add(t);
        }
        Object[] resArray = (Object[])Array.newInstance(compType, l.size());
        return l.toArray(resArray);
    }

    public static String nextNonEmptyLine(BufferedReader r) throws IOException {
        String s = r.readLine();
        while (s != null) {
            boolean foundHash = false;
            int hashPos = s.indexOf(35);
            if (hashPos >= 0) {
                foundHash = true;
                hashPos = (s = s.replace("\\#", "\u02ad")).indexOf(35);
                if (hashPos >= 0) {
                    s = s.substring(0, hashPos);
                }
            }
            if ((s = s.trim()).length() > 0) {
                if (foundHash) {
                    s = s.replace('\u02ad', '#');
                }
                return s;
            }
            s = r.readLine();
        }
        return null;
    }

    public static String[] filter(String[] ss, String prefix) {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(ss));
        Iterator<String> i = list.iterator();
        while (i.hasNext()) {
            if (!i.next().startsWith(prefix)) continue;
            i.remove();
        }
        return list.toArray(new String[list.size()]);
    }

    public static int[] parseIntList(String list) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        for (String s : list.split(",")) {
            if (s.contains("..")) {
                String[] sp = s.split("\\.\\.");
                int i1 = Integer.parseInt(sp[0]);
                int i2 = Integer.parseInt(sp[1]);
                for (int i = i1; i <= i2; ++i) {
                    res.add(i);
                }
                continue;
            }
            res.add(Integer.parseInt(s));
        }
        int[] is = new int[res.size()];
        for (int i = 0; i < res.size(); ++i) {
            is[i] = (Integer)res.get(i);
        }
        return is;
    }

    public static double[] parseDblList(String s) {
        ArrayList<Double> ll = new ArrayList<Double>();
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreElements()) {
            double v = Double.parseDouble(st.nextToken().trim());
            ll.add(v);
        }
        double[] res = new double[ll.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (Double)ll.get(i);
        }
        return res;
    }

    public static String[][] read2DimStrings(BufferedReader r, int numRows) throws IOException {
        String[][] ss = new String[numRows][];
        for (int i = 0; i < numRows; ++i) {
            ss[i] = Util.nextNonEmptyLine(r).trim().split("\\s+");
        }
        return ss;
    }

    public static double deleteArrayElement(double[] prios, int elemIdx, double fillWith) {
        double res = prios[elemIdx];
        System.arraycopy(prios, elemIdx + 1, prios, elemIdx, prios.length - elemIdx - 1);
        prios[prios.length - 1] = fillWith;
        return res;
    }

    public static <T> T deleteArrayElement(T[] prios, int elemIdx, T fillWith) {
        T res = prios[elemIdx];
        System.arraycopy(prios, elemIdx + 1, prios, elemIdx, prios.length - elemIdx - 1);
        prios[prios.length - 1] = fillWith;
        return res;
    }

    public static <T> T moveArrayElementToBack(T[] prios, int elemIdx) {
        T res = prios[elemIdx];
        System.arraycopy(prios, elemIdx + 1, prios, elemIdx, prios.length - elemIdx - 1);
        prios[prios.length - 1] = res;
        return res;
    }

    public static double mean(Collection<? extends Number> coll) {
        if (coll == null || coll.size() < 1) {
            throw new IllegalArgumentException();
        }
        double res = 0.0;
        for (Number number : coll) {
            res += number.doubleValue();
        }
        return res / (double)coll.size();
    }

    public static double stdDev(Collection<? extends Number> coll) {
        if (coll == null || coll.size() < 2) {
            throw new IllegalArgumentException();
        }
        double mean = Util.mean(coll);
        double res = 0.0;
        for (Number number : coll) {
            double d = number.doubleValue() - mean;
            res += d * d;
        }
        return res / (double)(coll.size() - 1);
    }

    public static double sum(double[] productMix) {
        if (productMix == null || productMix.length == 0) {
            throw new IllegalArgumentException(Arrays.toString(productMix));
        }
        double res = productMix[0];
        for (int i = 1; i < productMix.length; ++i) {
            res += productMix[i];
        }
        return res;
    }

    public static int sum(int[] is) {
        if (is == null || is.length == 0) {
            throw new IllegalArgumentException(Arrays.toString(is));
        }
        int res = is[0];
        for (int i = 1; i < is.length; ++i) {
            res += is[i];
        }
        return res;
    }

    public static int min(int[] vs) {
        if (vs == null || vs.length == 0) {
            throw new IllegalArgumentException(Arrays.toString(vs));
        }
        int min = vs[0];
        for (int i = 1; i < vs.length; ++i) {
            if (vs[i] >= min) continue;
            min = vs[i];
        }
        return min;
    }

    public static int minIdx(int[] vs) {
        return Util.minIdx(vs, 0);
    }

    public static int minIdx(int[] vs, int startIdx) {
        if (vs == null || vs.length == 0) {
            throw new IllegalArgumentException(Arrays.toString(vs));
        }
        int min = vs[startIdx];
        int minIdx = startIdx;
        for (int i = startIdx + 1; i < vs.length; ++i) {
            if (vs[i] >= min) continue;
            min = vs[i];
            minIdx = i;
        }
        return minIdx;
    }

    public static double min(double[] vs) {
        if (vs == null || vs.length == 0) {
            throw new IllegalArgumentException(Arrays.toString(vs));
        }
        double min = vs[0];
        for (int i = 1; i < vs.length; ++i) {
            if (!(vs[i] < min)) continue;
            min = vs[i];
        }
        return min;
    }

    public static int minIdx(double[] vs) {
        return Util.minIdx(vs, 0);
    }

    public static int minIdx(double[] vs, int startIdx) {
        if (vs == null || vs.length == 0) {
            throw new IllegalArgumentException(Arrays.toString(vs));
        }
        double min = vs[startIdx];
        int minIdx = startIdx;
        for (int i = startIdx + 1; i < vs.length; ++i) {
            if (!(vs[i] < min)) continue;
            min = vs[i];
            minIdx = i;
        }
        return minIdx;
    }

    public static int max(int[] vs) {
        if (vs == null || vs.length == 0) {
            throw new IllegalArgumentException(Arrays.toString(vs));
        }
        int max = vs[0];
        for (int i = 1; i < vs.length; ++i) {
            if (vs[i] <= max) continue;
            max = vs[i];
        }
        return max;
    }

    public static double max(double[] vs) {
        if (vs == null || vs.length == 0) {
            throw new IllegalArgumentException(Arrays.toString(vs));
        }
        double max = vs[0];
        for (int i = 1; i < vs.length; ++i) {
            if (!(vs[i] > max)) continue;
            max = vs[i];
        }
        return max;
    }

    public static int maxIdx(double[] vs) {
        if (vs == null || vs.length == 0) {
            throw new IllegalArgumentException(Arrays.toString(vs));
        }
        double max = vs[0];
        int maxIdx = 0;
        for (int i = 1; i < vs.length; ++i) {
            if (!(vs[i] > max)) continue;
            max = vs[i];
            maxIdx = i;
        }
        return maxIdx;
    }

    public static void shuffle(double[] arr, Random rnd) {
        for (int i = arr.length - 1; i > 0; --i) {
            int j = rnd.nextInt(i + 1);
            double tmp = arr[i];
            arr[i] = arr[j];
            arr[j] = tmp;
        }
    }

    public static void shuffle(int[] arr, Random rnd) {
        for (int i = arr.length - 1; i > 0; --i) {
            int j = rnd.nextInt(i + 1);
            int tmp = arr[i];
            arr[i] = arr[j];
            arr[j] = tmp;
        }
    }

    public static double round(double val, int decimals) {
        if (decimals >= 0) {
            long fact = Util.powerOfTen(decimals);
            return (double)Math.round(val * (double)fact) / (double)fact;
        }
        long fact = Util.powerOfTen(-decimals);
        return (double)Math.round(val / (double)fact) * (double)fact;
    }

    private static long powerOfTen(int exp) {
        assert (exp >= 0);
        long fact = 1L;
        for (int i = 0; i < exp; ++i) {
            fact *= 10L;
        }
        return fact;
    }

    public static double[] round(double[] vs, int decimals) {
        for (int i = 0; i < vs.length; ++i) {
            vs[i] = Util.round(vs[i], decimals);
        }
        return vs;
    }

    public static String arrayToString(Object arbitraryArray) throws IllegalArgumentException {
        Class<?> compType = arbitraryArray.getClass().getComponentType();
        if (compType == null) {
            throw new IllegalArgumentException();
        }
        if (compType.isPrimitive()) {
            if (compType == Integer.TYPE) {
                return Arrays.toString((int[])arbitraryArray);
            }
            if (compType == Long.TYPE) {
                return Arrays.toString((long[])arbitraryArray);
            }
            if (compType == Short.TYPE) {
                return Arrays.toString((short[])arbitraryArray);
            }
            if (compType == Byte.TYPE) {
                return Arrays.toString((byte[])arbitraryArray);
            }
            if (compType == Boolean.TYPE) {
                return Arrays.toString((boolean[])arbitraryArray);
            }
            if (compType == Double.TYPE) {
                return Arrays.toString((double[])arbitraryArray);
            }
            if (compType == Float.TYPE) {
                return Arrays.toString((float[])arbitraryArray);
            }
            if (compType == Character.TYPE) {
                return Arrays.toString((char[])arbitraryArray);
            }
            throw new AssertionError();
        }
        return Arrays.deepToString((Object[])arbitraryArray);
    }

    public static void putMeanMaxVar(SummaryStat vs, String prefix, Map<String, Object> res) {
        res.put(prefix + "Mean", vs);
        if (vs.numObs() > 0) {
            res.put(prefix + "Max", vs.max());
        }
        if (vs.numObs() >= 2) {
            res.put(prefix + "Variance", vs.variance());
        }
    }

    public static String getVersion() {
        return Util.getBuildProperty("jasima.version");
    }

    public static String getIdString() {
        return "JASIMA, v" + Util.getVersion() + "; http://jasima.net/";
    }

    public static String getJavaEnvString() {
        String javaVersion = System.getProperty("java.version");
        String javaVendor = System.getProperty("java.vendor");
        String javaVmName = System.getProperty("java.vm.name");
        return I18n.defFormat("java: v%s, %s (%s)", javaVersion, javaVmName, javaVendor);
    }

    public static String getOsEnvString() {
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        String osVersion = System.getProperty("os.version");
        return I18n.defFormat("os: %s (%s, v%s)", osName, osArch, osVersion);
    }

    public static String getWorkingDirString() {
        String userDir = System.getProperty("user.dir");
        return I18n.defFormat("dir: %s", userDir);
    }

    private static synchronized String getBuildProperty(String prop) {
        return buildProps.getProperty(prop, "!!!" + prop + "!!!");
    }

    private Util() {
    }

    static {
        try (InputStreamReader r = new InputStreamReader(Util.class.getResourceAsStream("/jasima/core/util/version.properties"), StandardCharsets.UTF_8);){
            buildProps.load(r);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DEF_POOL = Executors.newCachedThreadPool();
        DEF_CLASS_SEARCH_PATH = new String[]{"jasima.core.experiment", "jasima.core.expExecution", "jasima.core.random", "jasima.core.random.continuous", "jasima.core.random.discrete", "jasima.core.simulation", "jasima.core.simulation.arrivalprocess", "jasima.core.statistics", "jasima.core.util", "jasima.core.util.observer", "jasima.core.util.run", "jasima.shopSim.core", "jasima.shopSim.core.batchForming", "jasima.shopSim.models.dynamicShop", "jasima.shopSim.models.mimac", "jasima.shopSim.models.staticShop", "jasima.shopSim.prioRules.basic", "jasima.shopSim.prioRules.batch", "jasima.shopSim.prioRules.gp", "jasima.shopSim.prioRules.meta", "jasima.shopSim.prioRules.setup", "jasima.shopSim.prioRules.upDownStream", "jasima.shopSim.prioRules.weighted", "jasima.shopSim.util", "jasima.shopSim.util.modelDef", "jasima.shopSim.util.modelDef.streams"};
    }
}

