/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.util;

import jasima.core.util.Util;
import jasima.core.util.converter.TypeConverterJavaBean;
import jasima.core.util.converter.TypeToStringConverter;
import jasima.core.util.i18n.I18n;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.WeakHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class TypeUtil {
    private static WeakHashMap<Class<?>, Map<String, PropertyDescriptor>> propCache = null;
    private static final String PROP_JASIMA_EXPERIMENT = "jasima.experiment";
    private static final String PROP_SUN_JAVA_COMMAND = "sun.java.command";

    public static Class<?> getPropertyType(Object o, String propPath) throws RuntimeException {
        try {
            PropertyDescriptor match;
            String[] segments = propPath.split("\\.");
            for (int i = 0; i < segments.length - 1; ++i) {
                o = TypeUtil.handleSegmentGet(o, propPath, segments[i]);
            }
            String last = segments[segments.length - 1];
            int arrayElement = -1;
            if (last.contains("[")) {
                int i2;
                int i1 = propPath.indexOf(91);
                arrayElement = Integer.parseInt(propPath.substring(i1 + 1, i2 = propPath.indexOf(93)));
                if (arrayElement < 0) {
                    throw new IllegalArgumentException("invalid array/list access");
                }
                if (last.length() == i2 + 1) {
                    last = last.substring(0, i1);
                }
            }
            if ((match = TypeUtil.getPropertyDescriptor(o, last)) == null) {
                throw new IllegalArgumentException(I18n.defFormat("segment '%s' not found of property path '%s'.", last, propPath));
            }
            if (arrayElement == -1) {
                return match.getPropertyType();
            }
            if (match.getPropertyType().isArray()) {
                return match.getPropertyType().getComponentType();
            }
            if (List.class.isAssignableFrom(match.getPropertyType())) {
                return Object.class;
            }
            throw new IllegalArgumentException("not an array/list type");
        }
        catch (IllegalArgumentException | ReflectiveOperationException e1) {
            throw new RuntimeException(I18n.defFormat("Can't determine type of property '%s': %s", propPath, e1.toString()), e1);
        }
    }

    public static Object getPropertyValue(Object o, String propPath) throws RuntimeException {
        try {
            String[] segments = propPath.split("\\.");
            for (int i = 0; i < segments.length; ++i) {
                o = TypeUtil.handleSegmentGet(o, propPath, segments[i]);
            }
            return o;
        }
        catch (IllegalArgumentException | ReflectiveOperationException e1) {
            throw new RuntimeException(I18n.defFormat("Can't get property '%s'.", propPath), e1);
        }
    }

    private static Object handleSegmentGet(Object o, String propPath, String currSegment) throws IllegalAccessException, InvocationTargetException {
        PropertyDescriptor match;
        int arrayElement = -1;
        if (currSegment.contains("[")) {
            int i2;
            int i1 = currSegment.indexOf(91);
            arrayElement = Integer.parseInt(currSegment.substring(i1 + 1, i2 = currSegment.indexOf(93)));
            if (arrayElement < 0) {
                throw new IllegalArgumentException("invalid array/list access");
            }
            if (currSegment.length() == i2 + 1) {
                currSegment = currSegment.substring(0, i1);
            }
        }
        if ((match = TypeUtil.getPropertyDescriptor(o, currSegment)) == null) {
            throw new IllegalArgumentException(I18n.defFormat("segment '%s' not found of property path '%s'.", currSegment, propPath));
        }
        Method m = match.getReadMethod();
        o = m.invoke(o, new Object[0]);
        if (arrayElement >= 0) {
            if (o instanceof List) {
                o = ((List)o).get(arrayElement);
            } else if (o.getClass().isArray()) {
                o = Array.get(o, arrayElement);
            } else {
                throw new IllegalArgumentException(String.format("Can't get property '%s': '%s' is not an array or list.", propPath, o));
            }
        }
        return o;
    }

    public static void setPropertyValue(Object o, String propPath, Object value) {
        TypeUtil.setPropertyValue(o, propPath, value, TypeUtil.class.getClassLoader(), Util.DEF_CLASS_SEARCH_PATH);
    }

    public static void setPropertyValue(Object o, String propPath, Object value, ClassLoader loader, String[] packageSearchPath) throws IllegalArgumentException {
        String setPart;
        String getPart;
        int i = propPath.lastIndexOf(46);
        if (i >= 0) {
            getPart = propPath.substring(0, i);
            setPart = propPath.substring(i + 1);
        } else {
            getPart = "";
            setPart = propPath;
        }
        int arrayElement = -1;
        if (setPart.contains("[")) {
            int i2;
            int i1 = propPath.indexOf(91);
            arrayElement = Integer.parseInt(propPath.substring(i1 + 1, i2 = propPath.indexOf(93)));
            if (arrayElement < 0) {
                throw new IllegalArgumentException("invalid array/list access");
            }
            if (setPart.length() > i2 + 1) {
                throw new IllegalArgumentException(String.format("Can't set property '%s' to value '%s': invalid array access.", propPath, value));
            }
            if (getPart.length() > 0) {
                getPart = getPart + '.';
            }
            getPart = propPath.substring(0, i1);
            setPart = null;
        }
        Object target = o;
        if (getPart.length() > 0) {
            target = TypeUtil.getPropertyValue(o, getPart);
        }
        if (arrayElement == -1) {
            PropertyDescriptor desc = TypeUtil.getPropertyDescriptor(target, setPart);
            if (desc == null) {
                throw new IllegalArgumentException(I18n.defFormat("Segment '%s' not found of property path '%s'.", setPart, propPath));
            }
            value = TypeUtil.convert(value, desc.getPropertyType(), getPart, loader, packageSearchPath);
            try {
                desc.getWriteMethod().invoke(target, value);
            }
            catch (ReflectiveOperationException e1) {
                throw new IllegalArgumentException(String.format("Can't set property '%s' to value '%s': %s", propPath, value, TypeConverterJavaBean.exceptionMessage(e1)), e1);
            }
        } else {
            Class<?> arrayType = target.getClass();
            assert (TypeUtil.getPropertyType(o, getPart) == target.getClass());
            if (arrayType.isArray()) {
                value = TypeUtil.convert(value, arrayType.getComponentType(), getPart, loader, packageSearchPath);
                Array.set(target, arrayElement, value);
            } else if (List.class.isAssignableFrom(arrayType)) {
                value = TypeUtil.convert(value, Object.class, getPart, loader, packageSearchPath);
                List l = (List)target;
                l.set(arrayElement, value);
            } else {
                throw new IllegalArgumentException(String.format("Can't set property '%s' to value '%s': '%s' is not an array or list.", propPath, value, getPart));
            }
        }
    }

    public static <T> T convert(Object o, Class<T> requiredType, String context, ClassLoader l, String[] packageSearchPath) throws TypeConversionException {
        T value = o instanceof String && requiredType != String.class ? TypeToStringConverter.convertFromString((String)o, requiredType, context, l, packageSearchPath) : TypeUtil.basicConversions(o, requiredType);
        return value;
    }

    public static Class<?>[] computeClasses(Class<?> requiredType) {
        ArrayList<Class<Object>> resList = new ArrayList<Class<Object>>();
        ArrayDeque currStage = new ArrayDeque();
        HashSet seen = new HashSet();
        currStage.addLast(requiredType);
        seen.add(requiredType);
        while (!currStage.isEmpty()) {
            Class c = (Class)currStage.removeFirst();
            resList.add(c);
            Class s = c.getSuperclass();
            if (s != null && !seen.contains(s)) {
                currStage.addLast(s);
                seen.add(s);
            }
            for (Class<?> i : c.getInterfaces()) {
                if (seen.contains(i)) continue;
                currStage.addLast(i);
                seen.add(i);
            }
        }
        boolean hasObject = resList.remove(Object.class);
        if (hasObject) {
            resList.add(Object.class);
        }
        return resList.toArray(new Class[resList.size()]);
    }

    public static PropertyDescriptor[] findWritableProperties(Object o) {
        return TypeUtil.findWritableProperties(o.getClass());
    }

    public static Map<String, Object> getPropertyValues(Object o, PropertyDescriptor[] pds) {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        for (PropertyDescriptor pd : pds) {
            TypeUtil.getPropertyValue(o, pd, props);
        }
        return props;
    }

    private static void getPropertyValue(Object o, PropertyDescriptor pd, Map<String, Object> props) {
        try {
            props.put(pd.getName(), pd.getReadMethod().invoke(o, new Object[0]));
        }
        catch (Exception e) {
            throw new RuntimeException("error getting property value '" + pd.getName() + "'", e);
        }
    }

    public static PropertyDescriptor[] findWritableProperties(Class<?> c) {
        try {
            BeanInfo bi = Introspector.getBeanInfo(c);
            PropertyDescriptor[] pds = bi.getPropertyDescriptors();
            ArrayList<PropertyDescriptor> list = new ArrayList<PropertyDescriptor>(pds.length);
            for (PropertyDescriptor pd : pds) {
                if (pd.getWriteMethod() == null || pd.getReadMethod() == null) continue;
                list.add(pd);
            }
            return list.toArray(new PropertyDescriptor[list.size()]);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }

    private static PropertyDescriptor getPropertyDescriptor(Object o, String propName) {
        Map<String, PropertyDescriptor> props = TypeUtil.writableProperties(o.getClass());
        PropertyDescriptor desc = props.get(propName.toLowerCase(I18n.DEF_LOCALE));
        return desc;
    }

    private static <T> T basicConversions(Object o, Class<T> klass) throws TypeConversionException, NumberFormatException {
        if (o == null) {
            return null;
        }
        if (klass.isAssignableFrom(o.getClass())) {
            return (T)o;
        }
        assert (!(o instanceof String));
        if (klass == String.class) {
            return (T)TypeToStringConverter.convertToString(o);
        }
        if (klass == Integer.TYPE || klass == Integer.class) {
            if (o instanceof Number) {
                return (T)Integer.valueOf(((Number)o).intValue());
            }
            return (T)Integer.valueOf(TypeToStringConverter.convertToString(o));
        }
        if (klass == Long.TYPE || klass == Long.class) {
            if (o instanceof Number) {
                return (T)Long.valueOf(((Number)o).longValue());
            }
            return (T)Long.valueOf(TypeToStringConverter.convertToString(o));
        }
        if (klass == Double.TYPE || klass == Double.class) {
            if (o instanceof Number) {
                return (T)Double.valueOf(((Number)o).doubleValue());
            }
            return (T)Double.valueOf(TypeToStringConverter.convertToString(o));
        }
        if (klass == Boolean.TYPE || klass == Boolean.class) {
            String str = TypeToStringConverter.convertToString(o);
            if (str.equalsIgnoreCase("true") || str.equalsIgnoreCase("yes") || str.equalsIgnoreCase("1")) {
                return (T)Boolean.TRUE;
            }
            if (str.equalsIgnoreCase("false") || str.equalsIgnoreCase("no") || str.equalsIgnoreCase("0")) {
                return (T)Boolean.FALSE;
            }
            throw new TypeConversionException(I18n.defFormat("Can't convert '%s' to bool.", o));
        }
        if (klass.isEnum()) {
            return (T)Enum.valueOf(klass.asSubclass(Enum.class), TypeToStringConverter.convertToString(o));
        }
        if (klass == Byte.TYPE || klass == Byte.class) {
            if (o instanceof Number) {
                return (T)Byte.valueOf(((Number)o).byteValue());
            }
            return (T)Byte.valueOf(TypeToStringConverter.convertToString(o));
        }
        if (klass == Short.TYPE || klass == Short.class) {
            if (o instanceof Number) {
                return (T)Short.valueOf(((Number)o).shortValue());
            }
            return (T)Short.valueOf(TypeToStringConverter.convertToString(o));
        }
        if (klass == Float.TYPE || klass == Float.class) {
            if (o instanceof Number) {
                return (T)Float.valueOf(((Number)o).floatValue());
            }
            return (T)Float.valueOf(TypeToStringConverter.convertToString(o));
        }
        if (klass == Character.TYPE || klass == Character.class) {
            if (o instanceof Character) {
                return (T)((Character)o);
            }
            String s = TypeToStringConverter.convertToString(o);
            if (s.length() == 1) {
                return (T)Character.valueOf(s.charAt(0));
            }
        }
        throw new TypeConversionException(I18n.defFormat("Can't convert from '%s' to '%s'.", o.getClass().getName(), klass.getName()));
    }

    public static Map<String, PropertyDescriptor> writableProperties(Class<?> c) {
        Map<String, PropertyDescriptor> beanProps;
        if (propCache == null) {
            propCache = new WeakHashMap();
        }
        if ((beanProps = propCache.get(c)) == null) {
            PropertyDescriptor[] props = TypeUtil.findWritableProperties(c);
            beanProps = new HashMap<String, PropertyDescriptor>();
            for (PropertyDescriptor p : props) {
                beanProps.put(p.getName().toLowerCase(I18n.DEF_LOCALE), p);
            }
            propCache.put(c, beanProps);
        }
        return beanProps;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> T cloneIfPossible(T o9222) {
        void o9222;
        Object o9222;
        if (o9222 == null) {
            return null;
        }
        Class<?> ct = o9222.getClass().getComponentType();
        if (ct == null) {
            o9222 = TypeUtil.callClone(o9222);
            return o9222;
        } else if (ct.isPrimitive()) {
            if (ct == Integer.TYPE) {
                int[] o9222 = TypeUtil.deepCloneArrayIfPossible((int[])o9222);
                return o9222;
            } else if (ct == Double.TYPE) {
                double[] o9222 = TypeUtil.deepCloneArrayIfPossible((double[])o9222);
                return o9222;
            } else if (ct == Long.TYPE) {
                long[] o9222 = TypeUtil.deepCloneArrayIfPossible((long[])o9222);
                return o9222;
            } else if (ct == Boolean.TYPE) {
                boolean[] o9222 = TypeUtil.deepCloneArrayIfPossible((boolean[])o9222);
                return o9222;
            } else if (ct == Character.TYPE) {
                char[] o9222 = TypeUtil.deepCloneArrayIfPossible((char[])o9222);
                return o9222;
            } else if (ct == Float.TYPE) {
                float[] o9222 = TypeUtil.deepCloneArrayIfPossible((float[])o9222);
                return o9222;
            } else if (ct == Byte.TYPE) {
                byte[] o9222 = TypeUtil.deepCloneArrayIfPossible((byte[])o9222);
                return o9222;
            } else {
                if (ct != Short.TYPE) throw new AssertionError();
                short[] o9222 = TypeUtil.deepCloneArrayIfPossible((short[])o9222);
            }
            return o9222;
        } else {
            Object[] o9222 = TypeUtil.deepCloneArrayIfPossible((Object[])o9222);
        }
        return o9222;
    }

    private static <T> T callClone(T o) {
        try {
            Method cloneMethod = o.getClass().getMethod("clone", new Class[0]);
            return (T)cloneMethod.invoke(o, new Object[0]);
        }
        catch (NoSuchMethodException ignore) {
            return o;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T[] deepCloneArrayIfPossible(T[] array) {
        if (array == null) {
            return null;
        }
        Object[] clone = (Object[])array.clone();
        for (int i = 0; i < clone.length; ++i) {
            clone[i] = TypeUtil.cloneIfPossible(array[i]);
        }
        return clone;
    }

    public static int[] deepCloneArrayIfPossible(int[] array) {
        return (int[])array.clone();
    }

    public static long[] deepCloneArrayIfPossible(long[] array) {
        return (long[])array.clone();
    }

    public static byte[] deepCloneArrayIfPossible(byte[] array) {
        return (byte[])array.clone();
    }

    public static short[] deepCloneArrayIfPossible(short[] array) {
        return (short[])array.clone();
    }

    public static char[] deepCloneArrayIfPossible(char[] array) {
        return (char[])array.clone();
    }

    public static boolean[] deepCloneArrayIfPossible(boolean[] array) {
        return (boolean[])array.clone();
    }

    public static float[] deepCloneArrayIfPossible(float[] array) {
        return (float[])array.clone();
    }

    public static double[] deepCloneArrayIfPossible(double[] array) {
        return (double[])array.clone();
    }

    public static Class<?> getMainClass() throws ClassNotFoundException {
        String classOrJar;
        Properties props = System.getProperties();
        String main = (String)TypeUtil.findEntryCaseInsensitive(props, PROP_JASIMA_EXPERIMENT);
        if (main == null) {
            main = (String)TypeUtil.findEntryCaseInsensitive(props, PROP_SUN_JAVA_COMMAND);
        }
        if (main == null) {
            throw new RuntimeException(I18n.defFormat("Couldn't find properties '%s' or '%s'.", PROP_SUN_JAVA_COMMAND, PROP_JASIMA_EXPERIMENT));
        }
        try (Scanner s = new Scanner(main);){
            classOrJar = s.next();
        }
        try {
            Class<?> klazz = TypeUtil.class.getClassLoader().loadClass(classOrJar);
            return klazz;
        }
        catch (ClassNotFoundException e) {
            try {
                return TypeUtil.loadFromJar(classOrJar);
            }
            catch (IOException ignore) {
                throw e;
            }
        }
    }

    private static Class<?> loadFromJar(String classOrJar) throws IOException, ClassNotFoundException {
        try (JarFile jar = new JarFile(classOrJar);){
            Class<?> klazz;
            Manifest manifest = jar.getManifest();
            if (manifest == null) {
                throw new RuntimeException("MANIFEST.MF not found in jar.");
            }
            Attributes attributes = manifest.getMainAttributes();
            String mainClass = attributes.getValue("Rsrc-Main-Class");
            if (mainClass == null) {
                mainClass = attributes.getValue("Main-Class");
            }
            if (mainClass == null) {
                throw new RuntimeException("Couldn't determine main class.");
            }
            Class<?> clazz = klazz = TypeUtil.class.getClassLoader().loadClass(mainClass);
            return clazz;
        }
    }

    private static Object findEntryCaseInsensitive(Map<?, ?> jarEntries, String entry) {
        entry = entry.toLowerCase();
        for (Object o : jarEntries.keySet()) {
            String s = ((String)o).toLowerCase();
            if (!entry.equals(s)) continue;
            return jarEntries.get(o);
        }
        return null;
    }

    public static <E> Class<? extends E> getClassFromSystemProperty(String propertyName, Class<E> clazz, Class<? extends E> defaultClass) {
        Class<Object> result;
        ClassLoader cl = clazz.getClassLoader();
        String classname = System.getProperty(propertyName);
        if (classname == null) {
            result = defaultClass;
        } else {
            try {
                Class<?> class1 = Class.forName(classname, false, cl);
                result = class1.asSubclass(clazz);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static <T> T createInstance(Class<T> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
            throw new RuntimeException("error instantiating class " + clazz, e);
        }
    }

    public static void rethrowUncheckedException(Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new AssertionError();
    }

    public static <T> Class<? extends T> loadClass(String className, Class<T> requiredParentClass) throws ClassNotFoundException, ClassCastException {
        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        return clazz.asSubclass(requiredParentClass);
    }

    private TypeUtil() {
    }

    public static class TypeConversionException
    extends RuntimeException {
        private static final long serialVersionUID = -7073321632899508315L;

        public TypeConversionException(String s) {
            this(s, null);
        }

        public TypeConversionException(String s, Throwable cause) {
            super(s, cause);
        }
    }
}

