/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.util;

import jasima.core.simulation.SimComponent;
import jasima.core.simulation.SimComponentLifecycleListener;
import jasima.core.simulation.SimPrintMessage;
import jasima.core.simulation.Simulation;
import jasima.core.util.AbstractResultSaver;
import jasima.core.util.MsgCategory;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Consumer;

public class TraceFileProducer
implements SimComponentLifecycleListener,
Consumer<SimPrintMessage> {
    private String fileName;
    private PrintWriter log;
    private String name;

    public TraceFileProducer() {
    }

    public TraceFileProducer(String fileName) {
        this();
        this.setFileName(fileName);
    }

    @Override
    public void init(SimComponent sc) {
        Simulation sim = sc.getSim();
        sim.addPrintListener(this);
        sim.setPrintLevel(MsgCategory.TRACE);
    }

    @Override
    public void done(SimComponent sc) {
        if (this.log != null) {
            this.log.close();
            this.log = null;
        }
    }

    @Override
    public void accept(SimPrintMessage msg) {
        if (msg.getCategory() == MsgCategory.TRACE) {
            if (this.log == null) {
                this.createLogFile();
            }
            this.log.println(msg.getMessage());
        }
    }

    private void createLogFile() {
        try {
            this.name = this.getFileName();
            if (this.name == null) {
                this.name = "jasimaTrace" + new SimpleDateFormat("_yyyyMMdd_HHmmss").format(new Date());
                this.name = AbstractResultSaver.findFreeFile(this.name, ".txt") + ".txt";
            }
            this.log = new PrintWriter((Writer)new BufferedWriter(new FileWriter(this.name)), true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        String n = this.getFileName();
        if (n == null) {
            n = this.name;
        }
        return this.getClass().getSimpleName() + "(" + n + ")";
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}

