/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.util;

import jasima.core.simulation.SimContext;
import jasima.core.simulation.Simulation;
import java.util.Objects;

public class StateMachine<E extends Enum<E>> {
    Class<E> clazz;
    E currentState;
    E lastState;
    private long versionId = Long.MIN_VALUE;
    StateMachine<?> sub;

    public StateMachine(E initialState, E terminalState) {
        Objects.requireNonNull(initialState);
        Objects.requireNonNull(terminalState);
        if (((Enum)initialState).equals(terminalState)) {
            throw new IllegalArgumentException();
        }
        this.clazz = ((Enum)initialState).getDeclaringClass();
        this.lastState = initialState;
        this.currentState = this.lastState;
    }

    public void transition(E newState) {
        this.transitionIn(0.0, newState, null);
    }

    public void transition(E newState, Runnable onTransition) {
        this.transitionIn(0.0, newState, onTransition);
    }

    public void transitionNow(E newState) {
        this.transitionNow(newState, null);
    }

    public void transitionNow(E newState, Runnable onTransition) {
        StateMachine.runNonNull(this.onExit(this.currentState));
        this.lastState = this.currentState;
        this.currentState = newState;
        ++this.versionId;
        StateMachine.runNonNull(onTransition);
        StateMachine.runNonNull(this.onEnter(newState));
    }

    private Runnable onEnter(E newState) {
        return null;
    }

    private Runnable onExit(E currentState2) {
        return null;
    }

    private static void runNonNull(Runnable r) {
        if (r != null) {
            r.run();
        }
    }

    public void transitionIn(double simTimeDuration, E newState) {
        this.transitionIn(simTimeDuration, newState, null);
    }

    public void transitionIn(double simTimeDuration, E newState, Runnable onTransition) {
        Simulation sim = SimContext.requireSimContext();
        sim.scheduleIn(simTimeDuration, 0, () -> this.transitionNow(newState, onTransition));
    }

    public long versionId() {
        return this.versionId;
    }
}

