/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.util;

import jasima.core.simulation.SimProcess;
import jasima.core.simulation.Simulation;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;

public final class SimProcessUtil {
    private static final int DEF_THREAD_STACK_SIZE = 262144;
    private static final ExecutorService exec = Executors.newCachedThreadPool(SimProcessUtil::newWorkerThread);
    private static volatile ThreadGroup simThreads = null;
    private static final int threadStackSize = Integer.parseInt(System.getProperty(SimProcess.class.getName() + ".threadStackSize", "262144"));
    private static AtomicInteger threadNumber = new AtomicInteger(0);

    public static int numThreadsCreated() {
        return threadNumber.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static Thread newWorkerThread(Runnable r) {
        ThreadGroup tg = simThreads;
        if (tg == null || tg.isDestroyed()) {
            Class<SimProcessUtil> clazz = SimProcessUtil.class;
            // MONITORENTER : jasima.core.util.SimProcessUtil.class
            tg = simThreads;
            if (tg == null || tg.isDestroyed()) {
                tg = new ThreadGroup("jasimaSimThreads");
                tg.setDaemon(true);
                simThreads = tg;
            }
            // MONITOREXIT : clazz
        }
        Thread t = new Thread(simThreads, r, "jasimaSimThread-" + threadNumber.incrementAndGet(), threadStackSize);
        t.setDaemon(true);
        return t;
    }

    public static void pauseExecuting(Thread executor) {
        assert (executor == SimProcessUtil.currentExecutor());
        LockSupport.park();
    }

    public static void continueWith(Thread executor) {
        LockSupport.unpark(Objects.requireNonNull(executor));
    }

    public static void startExecuting(Runnable r) {
        exec.submit(r);
    }

    public static Thread currentExecutor() {
        return Thread.currentThread();
    }

    public static <R> SimCallable<R> simCallable(SimRunnable r) {
        return r == null ? null : new SimRunnableWrapper(r);
    }

    public static <R> SimCallable<R> simCallable(SimAction r) {
        return r == null ? null : new SimActionWrapper(r);
    }

    public static <R> SimCallable<R> simCallable(Callable<R> c) {
        return c == null ? null : new CallableWrapper<R>(c);
    }

    public static SimAction simAction(SimRunnable r) {
        return r == null ? null : new SimRunnableSimActionWrapper(r);
    }

    public static SimAction simActionFromRunnable(Runnable r) {
        return r == null ? null : new RunnableWrapper(r);
    }

    private SimProcessUtil() {
    }

    static final class CallableWrapper<R>
    implements SimCallable<R> {
        final Callable<R> c;

        CallableWrapper(Callable<R> task) {
            this.c = task;
        }

        @Override
        public R call(Simulation sim) throws SimProcess.MightBlock, Exception {
            return this.c.call();
        }
    }

    static final class SimActionWrapper<R>
    implements SimCallable<R> {
        final SimAction task;

        SimActionWrapper(SimAction task) {
            this.task = task;
        }

        @Override
        public R call(Simulation sim) throws SimProcess.MightBlock, Exception {
            this.task.run(sim);
            return null;
        }
    }

    static final class RunnableWrapper
    implements SimAction {
        final Runnable task;

        RunnableWrapper(Runnable task) {
            this.task = task;
        }

        @Override
        public void run(Simulation sim) throws SimProcess.MightBlock {
            this.task.run();
        }
    }

    static final class SimRunnableSimActionWrapper
    implements SimAction {
        final SimRunnable task;

        SimRunnableSimActionWrapper(SimRunnable task) {
            this.task = task;
        }

        @Override
        public void run(Simulation sim) throws SimProcess.MightBlock {
            this.task.run();
        }
    }

    static final class SimRunnableWrapper<R>
    implements SimCallable<R> {
        final SimRunnable task;

        SimRunnableWrapper(SimRunnable task) {
            this.task = task;
        }

        @Override
        public R call(Simulation sim) throws SimProcess.MightBlock {
            this.task.run();
            return null;
        }
    }

    @FunctionalInterface
    public static interface SimCallable<R> {
        public R call(Simulation var1) throws SimProcess.MightBlock, Exception;
    }

    @FunctionalInterface
    public static interface SimAction {
        public void run(Simulation var1) throws SimProcess.MightBlock;
    }

    @FunctionalInterface
    public static interface SimRunnable {
        public void run() throws SimProcess.MightBlock;
    }
}

