/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.util;

import jasima.core.simulation.Simulation;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public class SequenceNumberService {
    private final Map<String, AtomicInteger> values = new HashMap<String, AtomicInteger>();

    public static SequenceNumberService getFor(Simulation sim) {
        String serviceName = SequenceNumberService.class.getName();
        return (SequenceNumberService)sim.valueStoreUpdate(serviceName, oldService -> oldService != null ? oldService : new SequenceNumberService());
    }

    public int nextValue(String key) {
        AtomicInteger v = this.requireCounter(key);
        return v.incrementAndGet();
    }

    public String nextFormattedValue(String key) {
        return key + '-' + this.nextValue(key);
    }

    public int get(String key) {
        AtomicInteger v = this.values.get(key);
        return v != null ? v.get() : -1;
    }

    public void set(String key, int startValue) {
        if (startValue < 0 || key == null) {
            throw new IllegalArgumentException();
        }
        AtomicInteger v = this.requireCounter(key);
        v.set(startValue - 1);
    }

    private AtomicInteger requireCounter(String key) {
        return this.values.computeIfAbsent(Objects.requireNonNull(key), k -> new AtomicInteger(0));
    }
}

