/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.util;

import jasima.core.experiment.Experiment;
import jasima.core.util.AbstractResultSaver;
import jasima.core.util.Util;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ResultSaver
extends AbstractResultSaver {
    public static final String SER_EXTENSION = ".jasResBin";
    private static final int MAX_UNSAVED = 100;
    private static final long SAVE_INTERVAL = 300000L;
    private boolean saveSubExperiments = true;
    private ObjectOutputStream tmpDatOut;
    private int unsavedResults;
    private long nextSaveTime;
    private ArrayList<ColumnData> columns;

    @Override
    public void starting(Experiment e) {
        this.columns = new ArrayList();
        this.unsavedResults = 0;
        this.nextSaveTime = 0L;
        String f = this.getActualResultBaseName() + SER_EXTENSION;
        try {
            this.tmpDatOut = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(f)));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public boolean checkBaseName(String base) {
        return !new File(base + SER_EXTENSION).exists();
    }

    @Override
    public void multiExperimentCompletedTask(Experiment me, Experiment e, Map<String, Object> runRes) {
        if (this.isSaveSubExperiments()) {
            this.saveExperiment(e, runRes);
        }
    }

    @Override
    public void finished(Experiment e, Map<String, Object> results) {
        this.addCell(-3, null);
        this.columns.clear();
        this.saveExperiment(e, results);
        try {
            this.tmpDatOut.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void flushTmpFile() {
        try {
            this.tmpDatOut.flush();
            this.tmpDatOut.reset();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void addCell(int colIdx, Object value) {
        value = this.convertValue(value);
        try {
            this.tmpDatOut.writeObject(new CellData(colIdx, value));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private int getColumnIndex(String s, boolean isParamColumn) {
        int res = -1;
        for (int i = 0; i < this.columns.size(); ++i) {
            ColumnData cd = this.columns.get(i);
            if (!cd.name.equals(s) || cd.isParamColumn != isParamColumn) continue;
            res = i;
            break;
        }
        if (res < 0) {
            res = this.columns.size();
            ColumnData cd = new ColumnData(s, isParamColumn);
            this.addCell(-2, cd);
            this.columns.add(cd);
        }
        return res;
    }

    private void saveExperiment(Experiment e, Map<String, Object> runRes) {
        this.saveExperiment("", e, true);
        this.saveData(runRes);
        this.addCell(-1, null);
        ++this.unsavedResults;
        if (this.unsavedResults >= 100 || System.currentTimeMillis() > this.nextSaveTime) {
            this.flushTmpFile();
            this.unsavedResults = 0;
            this.nextSaveTime = System.currentTimeMillis() + 300000L;
        }
    }

    private void saveData(Map<String, Object> res) {
        for (String name : res.keySet()) {
            Object value = res.get(name);
            if (value != null && value instanceof Experiment) {
                this.saveExperiment(name + '.', (Experiment)value, false);
                continue;
            }
            int colIdx = this.getColumnIndex(name, false);
            this.addCell(colIdx, value);
        }
    }

    private void saveExperiment(String prefix, Experiment e, boolean isParam) {
        String cn = prefix + "className";
        int cnIdx = this.getColumnIndex(cn, isParam);
        this.addCell(cnIdx, e.getClass().getName());
        List factors = (List)e.valueStoreGet("@factors");
        if (factors != null) {
            for (int i = 0; i < factors.size(); ++i) {
                String f = (String)factors.get(i);
                int idx = f.indexOf(61);
                assert (idx >= 0);
                String name = f.substring(0, idx);
                String value = f.substring(idx + 1);
                int factIdx = this.getColumnIndex(prefix + "@factors" + "." + name, isParam);
                this.addCell(factIdx, value);
            }
        }
        Map<String, Object> ps = e.getPropsWithValues();
        for (String s : ps.keySet()) {
            Object v = ps.get(s);
            if (v != null && v instanceof Experiment) {
                this.saveExperiment(prefix + s + '.', (Experiment)v, isParam);
                continue;
            }
            int colIdx = this.getColumnIndex(prefix + s, isParam);
            this.addCell(colIdx, v);
        }
    }

    private Object convertValue(Object v) {
        if (v == null) {
            return "null";
        }
        if (v.getClass().isArray()) {
            return Util.arrayToString(v);
        }
        if (v instanceof Serializable) {
            return v;
        }
        return v.toString();
    }

    public boolean isSaveSubExperiments() {
        return this.saveSubExperiments;
    }

    public void setSaveSubExperiments(boolean saveSubExperiments) {
        this.saveSubExperiments = saveSubExperiments;
    }

    protected static class CellData
    implements Serializable {
        private static final long serialVersionUID = -1799390860125722470L;
        public final int colIdx;
        public final Object value;

        public CellData(int colIdx, Object value) {
            this.colIdx = colIdx;
            this.value = value;
        }
    }

    protected static class ColumnData
    implements Serializable {
        private static final long serialVersionUID = 3548750636065811872L;
        public final String name;
        public final boolean isParamColumn;
        public int sortedIndex;

        public ColumnData(String name, boolean isParamColumn) {
            this.name = name;
            this.isParamColumn = isParamColumn;
        }
    }
}

