/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.util;

import jasima.core.simulation.SimContext;
import jasima.core.simulation.Simulation;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.apache.logging.log4j.core.util.datetime.FastDateFormat;

@Plugin(name="jasima", category="Lookup")
public class Log4j2SimLookup
implements StrLookup {
    public static final String SIM_NAME = "simName";
    public static final String SIM_TIME = "simTime";
    public static final String SIM_TIME_ABS = "simTimeAbs";

    public String lookup(String key) {
        Simulation s = SimContext.currentSimulation();
        if (s == null) {
            return "no_sim";
        }
        if (SIM_NAME.equals(key)) {
            return s.toString();
        }
        if (key.startsWith(SIM_TIME_ABS)) {
            return this.formatSimTimeAbs(key, s);
        }
        if (key.equals(SIM_TIME)) {
            return this.formatSimTime(key, s);
        }
        return "UNKNOWN_KEY:" + key;
    }

    private String formatSimTime(String key, Simulation s) {
        return Double.toString(s.simTime());
    }

    private String formatSimTimeAbs(String key, Simulation s) {
        FastDateFormat formatter;
        if (key.length() == SIM_TIME_ABS.length()) {
            formatter = FastDateFormat.getDateTimeInstance((int)3, (int)3, (TimeZone)TimeZone.getTimeZone(s.getZoneId()), (Locale)s.getLocale());
        } else {
            String params = key.substring(SIM_TIME_ABS.length());
            assert (params.startsWith(":"));
            formatter = FastDateFormat.getInstance((String)params.substring(1), (TimeZone)TimeZone.getTimeZone(s.getZoneId()), (Locale)s.getLocale());
        }
        return formatter.format(s.simTimeAbs().toEpochMilli());
    }

    public String lookup(LogEvent event, String key) {
        assert (event.getThreadName() == Thread.currentThread().getName());
        return this.lookup(key);
    }
}

