/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.util;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.javabean.JavaBeanConverter;
import com.thoughtworks.xstream.converters.javabean.JavaBeanProvider;
import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.HashSet;

public class JasimaBeanConverter
extends JavaBeanConverter {
    protected static final String NULL_ATTRIBUTE_NAME = "is-null";
    protected static final String NULL_ATTRIBUTE_VALUE = "yes";
    protected boolean saveExtendedInfo;

    public JasimaBeanConverter(Mapper mapper, boolean saveExtendedInfo) {
        super(mapper);
        this.saveExtendedInfo = saveExtendedInfo;
    }

    public void marshal(final Object source, final HierarchicalStreamWriter writer, final MarshallingContext context) {
        if (!this.saveExtendedInfo) {
            super.marshal(source, writer, context);
            return;
        }
        final String classAttributeName = this.mapper.aliasForSystemAttribute("class");
        this.beanProvider.visitSerializableProperties(source, new JavaBeanProvider.Visitor(){

            public boolean shouldVisit(String name, Class definedIn) {
                return JasimaBeanConverter.this.mapper.shouldSerializeMember(definedIn, name);
            }

            public void visit(String propertyName, Class fieldType, Class definedIn, Object newObj) {
                if (newObj == null) {
                    writer.startNode(propertyName);
                    writer.addAttribute(classAttributeName, "null");
                    writer.endNode();
                } else {
                    Class<?> actualType = newObj.getClass();
                    String serializedMember = JasimaBeanConverter.this.mapper.serializedMember(source.getClass(), propertyName);
                    ExtendedHierarchicalStreamWriterHelper.startNode((HierarchicalStreamWriter)writer, (String)serializedMember, actualType);
                    writer.addAttribute(classAttributeName, JasimaBeanConverter.this.mapper.serializedClass(actualType));
                    context.convertAnother(newObj);
                    writer.endNode();
                }
            }
        });
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Object result = this.instantiate(context);
        HashSet<String> seenProperties = new HashSet<String>();
        Class<?> resultType = result.getClass();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String propertyName = this.mapper.realMember(resultType, reader.getNodeName());
            if (this.mapper.shouldSerializeMember(resultType, propertyName)) {
                if (!seenProperties.add(propertyName)) {
                    throw new JavaBeanConverter.DuplicatePropertyException(propertyName);
                }
                Object value = NULL_ATTRIBUTE_VALUE.equals(reader.getAttribute(NULL_ATTRIBUTE_NAME)) ? null : context.convertAnother(result, this.determineType(reader, result, propertyName));
                this.beanProvider.writeProperty(result, propertyName, value);
            }
            reader.moveUp();
        }
        return result;
    }

    protected Object instantiate(UnmarshallingContext context) {
        Object result = context.currentObject();
        if (result == null) {
            result = this.beanProvider.newInstance(context.getRequiredType());
        }
        return result;
    }

    protected Class<?> determineType(HierarchicalStreamReader reader, Object result, String fieldName) {
        String classAttribute;
        String classAttributeName = this.mapper.aliasForSystemAttribute("class");
        String string = classAttribute = classAttributeName == null ? null : reader.getAttribute(classAttributeName);
        if (classAttribute != null) {
            return this.mapper.realClass(classAttribute);
        }
        return this.mapper.defaultImplementationOf(this.beanProvider.getPropertyType(result, fieldName));
    }
}

