/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.util;

import jasima.core.statistics.SummaryStat;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.math3.util.Precision;
import org.hamcrest.CoreMatchers;
import org.junit.Rule;
import org.junit.rules.ErrorCollector;

public class ExperimentTest {
    @Rule
    public ErrorCollector errorCollector = new ErrorCollector();
    protected int maxUlps = 10;

    protected void checkKeySets(Map<String, Object> resActual, Map<String, Object> resExpected) {
        HashSet<String> keysAct = new HashSet<String>(resActual.keySet());
        HashSet<String> keysExp = new HashSet<String>(resExpected.keySet());
        HashSet<String> all = new HashSet<String>();
        all.addAll(keysAct);
        all.addAll(keysExp);
        HashSet onlyExp = new HashSet(all);
        onlyExp.removeAll(keysAct);
        HashSet onlyAct = new HashSet(all);
        onlyAct.removeAll(keysExp);
        this.errorCollector.checkThat("key sets should be equal.\nkeys missing in actual result map: " + onlyExp + ";\nkeys only in actual result map: " + onlyAct, keysAct, CoreMatchers.is(keysExp));
    }

    protected void checkResults(Map<String, Object> resActual, Map<String, Object> resExpected) {
        for (String name : resExpected.keySet()) {
            Number act;
            Number exp;
            if ("runTime".equals(name) || name.endsWith(".runTime")) continue;
            this.errorCollector.checkThat(name, resActual.keySet(), CoreMatchers.hasItem((Object)name));
            Object expected = resExpected.get(name);
            Object actual = resActual.get(name);
            if (actual == null) continue;
            name = "result entry '" + name + "'";
            if (expected instanceof SummaryStat) {
                this.checkValueStat(name, (SummaryStat)expected, (SummaryStat)actual);
                continue;
            }
            if (expected instanceof Double) {
                exp = (Number)expected;
                act = (Number)actual;
                this.checkDouble(name, act.doubleValue(), exp.doubleValue());
                continue;
            }
            if (expected instanceof Double) {
                exp = (Number)expected;
                act = (Number)actual;
                this.checkDouble(name, act.doubleValue(), exp.doubleValue());
                continue;
            }
            this.errorCollector.checkThat(name, actual, CoreMatchers.is((Object)expected));
        }
    }

    protected void checkFloat(String name, float act, float exp) {
        if (act != exp) {
            boolean cmp = Precision.equals((float)act, (float)exp, (int)this.maxUlps);
            this.errorCollector.checkThat(name + ";  act: " + act + ";  exp: " + exp, (Object)cmp, CoreMatchers.is((Object)true));
        }
    }

    protected void checkDouble(String name, double act, double exp) {
        if (Double.compare(exp, act) != 0) {
            boolean cmp = Precision.equals((double)act, (double)exp, (int)this.maxUlps);
            this.errorCollector.checkThat(name + ";  act: " + act + ";  exp: " + exp, (Object)cmp, CoreMatchers.is((Object)true));
        }
    }

    protected void checkValueStat(String name, SummaryStat exp, SummaryStat act) {
        this.errorCollector.checkThat(name + " (numObs)", (Object)act.numObs(), CoreMatchers.is((Object)exp.numObs()));
        this.checkDouble(name + " (weightSum)", act.weightSum(), exp.weightSum());
        this.checkDouble(name + " (mean)", act.mean(), exp.mean());
        this.checkDouble(name + " (min)", act.min(), exp.min());
        this.checkDouble(name + " (max)", act.max(), exp.max());
        this.checkDouble(name + " (stdDev)", act.stdDev(), exp.stdDev());
    }
}

