/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.util;

import jasima.core.experiment.Experiment;
import jasima.core.statistics.SummaryStat;
import jasima.core.util.MsgCategory;
import jasima.core.util.ResultSaver;
import jasima.core.util.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.CellFormat;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormats;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;

public class ExcelSaver
extends ResultSaver {
    public static final String XLS_EXTENSION = ".xls";
    private static final String SHEET_NAME_MAIN = "main experiment";
    private static final String SHEET_NAME_OVERVIEW = "sub-exp. overview";
    private static final String SHEET_NAME_MEAN = "sub-exp. value|mean";
    private static final String SHEET_NAME_MIN = "sub-exp. min";
    private static final String SHEET_NAME_MAX = "sub-exp. max";
    private static final String SHEET_NAME_SD = "sub-exp. stdDev";
    private static final String SHEET_NAME_COUNT = "sub-exp. count";
    private static final String[] SUB_RES_SHEETS = new String[]{"sub-exp. value|mean", "sub-exp. min", "sub-exp. max", "sub-exp. stdDev", "sub-exp. count"};
    public static final int MAX_ROWS = 65536;
    public static final int MAX_COLUMNS = 256;
    private boolean keepDataFile = false;
    private boolean transpose = false;
    private int maxParamValues = 100;
    private int maxStringLength = 16000;
    private WritableWorkbook workbook;
    private Map<String, Set<Object>> paramValues;
    private ArrayList<ResultSaver.ColumnData> columns;
    private ArrayList<ResultSaver.ColumnData> mainExpColumns;
    private final WritableCellFormat headerCellFormat;
    private final WritableCellFormat defFormat;
    private final WritableCellFormat intFormat;
    private final WritableCellFormat floatFormat;

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("usage: " + ExcelSaver.class.getName() + " <file1ToConvert> [<file2ToConvert> ...]");
            return;
        }
        for (String a : args) {
            File in = new File(a);
            File out = new File(a + XLS_EXTENSION);
            System.out.println("reading '" + in.toString() + "', writing to '" + out.toString() + "'...");
            if (out.exists()) {
                System.out.println("  skipping '" + out + "', file already exists.");
                continue;
            }
            try {
                ExcelSaver es = new ExcelSaver();
                es.convertFile(in, out);
                System.out.println("  done.");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertFile(File in, File out) throws IOException {
        ObjectInputStream is = new ObjectInputStream(new BufferedInputStream(new FileInputStream(in)));
        OutputStream os = null;
        try {
            this.readColumns(is);
            is.close();
            is = null;
            is = new ObjectInputStream(new BufferedInputStream(new FileInputStream(in)));
            os = new BufferedOutputStream(new FileOutputStream(out));
            this.convertToExcelFile(is, os);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public ExcelSaver() {
        WritableFont arial10ptBold = new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD);
        this.headerCellFormat = new WritableCellFormat(arial10ptBold);
        this.defFormat = new WritableCellFormat(NumberFormats.DEFAULT);
        this.intFormat = new WritableCellFormat(NumberFormats.INTEGER);
        this.floatFormat = new WritableCellFormat(NumberFormats.FLOAT);
    }

    public ExcelSaver(String fileNameHint) {
        this();
        this.setFileNameHint(fileNameHint);
    }

    @Override
    public void finished(Experiment e, Map<String, Object> results) {
        super.finished(e, results);
        File tmp = new File(this.getActualResultBaseName() + ".jasResBin");
        File out = new File(this.getActualResultBaseName() + XLS_EXTENSION);
        e.print(MsgCategory.INFO, "writing results to Excel file '%s'...", out.getName());
        try {
            this.convertFile(tmp, out);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        if (!this.isKeepDataFile()) {
            tmp.delete();
        }
        e.print(MsgCategory.INFO, "done.");
    }

    @Override
    public boolean checkBaseName(String base) {
        if (!super.checkBaseName(base)) {
            return false;
        }
        return !new File(base + XLS_EXTENSION).exists();
    }

    protected void convertToExcelFile(ObjectInputStream is, OutputStream os) {
        try {
            WorkbookSettings ws = new WorkbookSettings();
            this.workbook = Workbook.createWorkbook((OutputStream)os, (WorkbookSettings)ws);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            this.writeMainExpHeader();
            if (this.columns.size() > 0) {
                this.writeSubExpColumnHeaders();
            }
            boolean isSubExp = true;
            try {
                int row = 1;
                while (true) {
                    ResultSaver.CellData cd = (ResultSaver.CellData)is.readObject();
                    if (cd.colIdx == -3) {
                        isSubExp = false;
                        continue;
                    }
                    if (isSubExp) {
                        if (cd.colIdx == -1) {
                            ++row;
                            continue;
                        }
                        this.handleSubExpData(row, cd);
                        continue;
                    }
                    this.handleMainExpData(cd);
                }
            }
            catch (EOFException eOFException) {
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            this.workbook.write();
            this.workbook.close();
            this.workbook = null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeMainExpHeader() throws Exception {
        ArrayList<ResultSaver.ColumnData> sortedColumns = new ArrayList<ResultSaver.ColumnData>(this.mainExpColumns);
        Collections.sort(sortedColumns, new Comparator<ResultSaver.ColumnData>(){

            @Override
            public int compare(ResultSaver.ColumnData cd1, ResultSaver.ColumnData cd2) {
                if (cd1.isParamColumn && !cd2.isParamColumn) {
                    return -1;
                }
                if (!cd1.isParamColumn && cd2.isParamColumn) {
                    return 1;
                }
                return cd1.name.compareToIgnoreCase(cd2.name);
            }
        });
        this.addHeaderCell(SHEET_NAME_MAIN, 0, 0, "parameters:");
        this.addHeaderCell(SHEET_NAME_MAIN, 0, 1, "name");
        this.addHeaderCell(SHEET_NAME_MAIN, 0, 2, "value");
        boolean params = true;
        int n = 1;
        for (int i = 0; i < sortedColumns.size(); ++i) {
            ResultSaver.ColumnData cd = sortedColumns.get(i);
            if (!cd.isParamColumn && params) {
                this.addHeaderCell(SHEET_NAME_MAIN, ++n, 0, "results:");
                this.addHeaderCell(SHEET_NAME_MAIN, n, 1, "name");
                this.addHeaderCell(SHEET_NAME_MAIN, n, 2, "value/mean");
                this.addHeaderCell(SHEET_NAME_MAIN, n, 3, "min");
                this.addHeaderCell(SHEET_NAME_MAIN, n, 4, "max");
                this.addHeaderCell(SHEET_NAME_MAIN, n, 5, "stdDev");
                this.addHeaderCell(SHEET_NAME_MAIN, n, 6, "count");
                this.addHeaderCell(SHEET_NAME_MAIN, n, 7, "sum");
                params = false;
            }
            int n2 = ++n;
            ++n;
            cd.sortedIndex = n2;
            this.addCell(SHEET_NAME_MAIN, cd.sortedIndex, 1, cd.name);
        }
    }

    private void handleMainExpData(ResultSaver.CellData cd) throws Exception {
        if (cd.colIdx >= 0) {
            ResultSaver.ColumnData col = this.mainExpColumns.get(cd.colIdx);
            if (col.sortedIndex >= 0) {
                if (cd.value instanceof SummaryStat) {
                    SummaryStat s = (SummaryStat)cd.value;
                    this.addCell(SHEET_NAME_MAIN, col.sortedIndex, 2, s.mean());
                    this.addCell(SHEET_NAME_MAIN, col.sortedIndex, 3, s.min());
                    this.addCell(SHEET_NAME_MAIN, col.sortedIndex, 4, s.max());
                    this.addCell(SHEET_NAME_MAIN, col.sortedIndex, 5, s.stdDev());
                    this.addCell(SHEET_NAME_MAIN, col.sortedIndex, 6, s.numObs());
                    this.addCell(SHEET_NAME_MAIN, col.sortedIndex, 7, s.sum());
                } else {
                    this.addCell(SHEET_NAME_MAIN, col.sortedIndex, 2, cd.value);
                }
            }
        } else if (cd.colIdx != -2) assert (cd.colIdx == -1);
    }

    protected void readColumns(ObjectInputStream is) {
        this.paramValues = new HashMap<String, Set<Object>>();
        this.columns = new ArrayList();
        this.mainExpColumns = new ArrayList();
        boolean isSubExp = true;
        try {
            try {
                while (true) {
                    ResultSaver.ColumnData col;
                    ResultSaver.CellData cd = (ResultSaver.CellData)is.readObject();
                    if (cd.colIdx == -1) continue;
                    if (cd.colIdx == -3) {
                        isSubExp = false;
                        continue;
                    }
                    if (cd.colIdx == -2) {
                        col = (ResultSaver.ColumnData)cd.value;
                        if (isSubExp) {
                            this.columns.add(col);
                            continue;
                        }
                        this.mainExpColumns.add(col);
                        continue;
                    }
                    if (!isSubExp) continue;
                    col = this.columns.get(cd.colIdx);
                    if (!col.isParamColumn) continue;
                    Set<Object> values = this.paramValues.get(col.name);
                    if (values == null) {
                        values = new LinkedHashSet<Object>();
                        this.paramValues.put(col.name, values);
                    }
                    values.add(this.convertToString(cd.value));
                }
            }
            catch (EOFException cd) {
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeSubExpColumnHeaders() throws Exception {
        ArrayList<ResultSaver.ColumnData> sortedColumns = new ArrayList<ResultSaver.ColumnData>(this.columns);
        Collections.sort(sortedColumns, new Comparator<ResultSaver.ColumnData>(){

            @Override
            public int compare(ResultSaver.ColumnData cd1, ResultSaver.ColumnData cd2) {
                if (cd1.isParamColumn && !cd2.isParamColumn) {
                    return -1;
                }
                if (!cd1.isParamColumn && cd2.isParamColumn) {
                    return 1;
                }
                return cd1.name.compareToIgnoreCase(cd2.name);
            }
        });
        this.addHeaderCell(SHEET_NAME_OVERVIEW, 0, 0, "parameters used (constant parameters are not shown on other sheets)");
        this.addHeaderCell(SHEET_NAME_OVERVIEW, 2, 0, "name");
        this.addHeaderCell(SHEET_NAME_OVERVIEW, 2, 1, "distinct values");
        this.addHeaderCell(SHEET_NAME_OVERVIEW, 2, 2, "value 1");
        this.addHeaderCell(SHEET_NAME_OVERVIEW, 2, 3, "value 2");
        this.addHeaderCell(SHEET_NAME_OVERVIEW, 2, 4, "...");
        int n = 0;
        block0: for (int i = 0; i < sortedColumns.size(); ++i) {
            ResultSaver.ColumnData cd = sortedColumns.get(i);
            Set<Object> values = this.paramValues.get(cd.name);
            cd.sortedIndex = cd.isParamColumn && values != null && values.size() == 1 ? -1 : n++;
            if (!cd.isParamColumn) continue;
            this.addCell(SHEET_NAME_OVERVIEW, i + 3, 0, cd.name);
            this.addCell(SHEET_NAME_OVERVIEW, i + 3, 1, values.size());
            int j = 2;
            int num = 0;
            for (Object v : values) {
                if (this.getMaxParamValues() > 0 && ++num == this.getMaxParamValues() + 1) {
                    String moreString = "... " + (values.size() - num + 1) + " more ...";
                    this.addCell(SHEET_NAME_OVERVIEW, i + 3, j++, moreString);
                    continue block0;
                }
                this.addCell(SHEET_NAME_OVERVIEW, i + 3, j++, v);
            }
        }
        boolean params = true;
        this.addHeaderCell(SHEET_NAME_MEAN, 0, 0, "parameters:");
        for (ResultSaver.ColumnData cd : sortedColumns) {
            if (cd.sortedIndex == -1) continue;
            if (!cd.isParamColumn && params) {
                this.addCellEachSheet(0, cd.sortedIndex + 1, "results:");
                params = false;
            }
            cd.sortedIndex = !params ? (cd.sortedIndex += 2) : ++cd.sortedIndex;
            if (!cd.isParamColumn) {
                this.addCellEachSheet(0, cd.sortedIndex, cd.name);
                continue;
            }
            this.addHeaderCell(SHEET_NAME_MEAN, 0, cd.sortedIndex, cd.name);
        }
    }

    private void handleSubExpData(int row, ResultSaver.CellData cd) throws Exception {
        if (cd.colIdx >= 0) {
            ResultSaver.ColumnData col = this.columns.get(cd.colIdx);
            if (col.sortedIndex >= 0) {
                if (cd.value instanceof SummaryStat) {
                    SummaryStat s = (SummaryStat)cd.value;
                    this.addCell(SHEET_NAME_MEAN, row, col.sortedIndex, s.mean());
                    this.addCell(SHEET_NAME_MIN, row, col.sortedIndex, s.min());
                    this.addCell(SHEET_NAME_MAX, row, col.sortedIndex, s.max());
                    this.addCell(SHEET_NAME_SD, row, col.sortedIndex, s.stdDev());
                    this.addCell(SHEET_NAME_COUNT, row, col.sortedIndex, s.numObs());
                } else {
                    this.addCell(SHEET_NAME_MEAN, row, col.sortedIndex, cd.value);
                }
            }
        } else assert (cd.colIdx == -2);
    }

    private void addHeaderCell(String sheetName, int row, int column, String string) throws Exception {
        this.addCell0(sheetName, row, column, string, this.headerCellFormat);
    }

    private void addCell(String sheetName, int row, int column, Object o) throws Exception {
        this.addCell0(sheetName, row, column, o, this.defFormat);
    }

    private void addCellEachSheet(int row0, int col0, String value) throws Exception {
        for (String sheet : SUB_RES_SHEETS) {
            this.addHeaderCell(sheet, row0, col0, value);
        }
    }

    private void addCell0(String sheetBaseName, int row0, int col0, Object value, WritableCellFormat format) throws Exception {
        int row = row0;
        int col = col0;
        if (this.isTranspose()) {
            int tmp = row;
            row = col;
            col = tmp;
        }
        int sheetNum = col / 256;
        col %= 256;
        if (sheetNum > 0) {
            sheetBaseName = sheetBaseName + " - c" + sheetNum;
        }
        int sheetNum2 = row / 65536;
        row %= 65536;
        if (sheetNum2 > 0) {
            sheetBaseName = sheetBaseName + " - r" + sheetNum2;
        }
        WritableSheet valSheet = this.getOrCreateSheet(sheetBaseName);
        if (!(value instanceof java.lang.Number)) {
            value = this.convertToString(value);
        }
        if (value instanceof java.lang.Number) {
            valSheet.addCell(this.createCell4Number(col, row, (java.lang.Number)value));
        } else {
            valSheet.addCell((WritableCell)new Label(col, row, (String)value, (CellFormat)format));
        }
    }

    private String convertToString(Object o) {
        String res = o == null ? "null" : (o.getClass().isArray() ? Util.arrayToString(o) : o.toString());
        if (this.getMaxStringLength() > 0 && res.length() > this.getMaxStringLength()) {
            int diff = res.length() - this.getMaxStringLength();
            String s = "... " + diff + " more characters ...";
            if (this.getMaxStringLength() + s.length() < res.length()) {
                res = res.substring(0, this.getMaxStringLength()) + s;
            }
        }
        return res;
    }

    private WritableCell createCell4Number(int col, int row, java.lang.Number n) {
        double v = n.doubleValue();
        if (Double.isNaN(v)) {
            return new Label(col, row, "NaN");
        }
        if (Double.POSITIVE_INFINITY == v) {
            return new Label(col, row, "+INF");
        }
        if (Double.NEGATIVE_INFINITY == v) {
            return new Label(col, row, "-INF");
        }
        if (n.getClass() == Long.class) {
            return new Label(col, row, n.toString());
        }
        WritableCellFormat f = this.defFormat;
        if (n.getClass() == Double.class || n.getClass() == Float.class) {
            f = this.floatFormat;
        } else if (n.getClass() == Integer.class || n.getClass() == Long.class || n.getClass() == Short.class || n.getClass() == Byte.class) {
            f = this.intFormat;
        }
        return new Number(col, row, v, (CellFormat)f);
    }

    private WritableSheet getOrCreateSheet(String sheetBaseName) {
        WritableSheet s = this.workbook.getSheet(sheetBaseName);
        if (s == null) {
            s = this.workbook.createSheet(sheetBaseName, Integer.MAX_VALUE);
        }
        return s;
    }

    public boolean isTranspose() {
        return this.transpose;
    }

    public void setTranspose(boolean transpose) {
        this.transpose = transpose;
    }

    public boolean isKeepDataFile() {
        return this.keepDataFile;
    }

    public void setKeepDataFile(boolean keepDataFile) {
        this.keepDataFile = keepDataFile;
    }

    public int getMaxParamValues() {
        return this.maxParamValues;
    }

    public void setMaxParamValues(int maxParamValues) {
        if (maxParamValues < 0) {
            throw new IllegalArgumentException("maxParamValues mustn't be negative. " + maxParamValues);
        }
        this.maxParamValues = maxParamValues;
    }

    public int getMaxStringLength() {
        return this.maxStringLength;
    }

    public void setMaxStringLength(int maxStringLength) {
        if (maxStringLength < 0) {
            throw new IllegalArgumentException("maxStringLength mustn't be negative. " + maxStringLength);
        }
        this.maxStringLength = maxStringLength;
    }
}

