/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.util;

import jasima.core.experiment.AbstractMultiExperiment;
import jasima.core.experiment.Experiment;
import jasima.core.experiment.ExperimentListener;
import jasima.core.experiment.ExperimentMessage;
import jasima.core.simulation.SimEvent;
import jasima.core.simulation.Simulation;
import jasima.core.statistics.SummaryStat;
import jasima.core.util.MsgCategory;
import jasima.core.util.Util;
import jasima.core.util.i18n.I18n;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;

public class ConsolePrinter
implements ExperimentListener {
    private MsgCategory logLevel = MsgCategory.DEBUG;
    private Locale locale = I18n.DEF_LOCALE;
    private String logFormat = "%1$tT.%1$tL\t%4$s\t%2$s\t%3$s";
    private PrintWriter out = null;
    private boolean printStdEvents = true;

    public ConsolePrinter() {
        this(null, null);
    }

    public ConsolePrinter(MsgCategory logLevel) {
        this(logLevel, null);
    }

    public ConsolePrinter(String logFormat) {
        this(null, logFormat);
    }

    public ConsolePrinter(MsgCategory logLevel, String logFormat) {
        if (logLevel != null) {
            this.setLogLevel(logLevel);
        }
        if (logFormat != null) {
            this.setLogFormat(logFormat);
        }
    }

    @Override
    public void print(Experiment e, ExperimentMessage.ExpPrintMessage event) {
        if (event.category.ordinal() <= this.getLogLevel().ordinal()) {
            String name = e.toString();
            String msg = String.format(this.getLocale(), this.getLogFormat(), new Date(), event.category.toString(), event.getMessage(this.getLocale()), name);
            if (this.getOut() == null) {
                System.out.println(msg);
            } else {
                this.getOut().println(msg);
            }
        }
    }

    @Override
    public void starting(Experiment e) {
        if (this.isPrintStdEvents()) {
            e.print("starting...");
        }
    }

    @Override
    public void initialized(Experiment e) {
        if (this.isPrintStdEvents()) {
            e.print("initializing...");
        }
    }

    @Override
    public void beforeRun(Experiment e) {
        if (this.isPrintStdEvents()) {
            e.print("running...");
        }
    }

    @Override
    public void afterRun(Experiment e) {
        if (this.isPrintStdEvents()) {
            e.print("terminating...");
        }
    }

    @Override
    public void done(Experiment e) {
        if (this.isPrintStdEvents()) {
            e.print("collecting results...");
        }
    }

    @Override
    public void finished(Experiment e, Map<String, Object> results) {
        if (this.isPrintStdEvents()) {
            e.print("finished.");
        }
    }

    @Override
    public void error(Experiment e, Throwable t) {
        if (this.isPrintStdEvents()) {
            e.print("there was an exception: %s", t);
        }
    }

    @Override
    public void multiExperimentCompletedTask(Experiment e, Experiment runExperiment, Map<String, Object> runResults) {
        if (this.isPrintStdEvents() && e instanceof AbstractMultiExperiment) {
            AbstractMultiExperiment me = (AbstractMultiExperiment)e;
            Double runTime = (Double)runResults.get("runTime");
            Integer aborted = (Integer)runResults.get("expAborted");
            String errorMsg = (String)runResults.get("exceptionMessage");
            String abortStr = "";
            if (aborted != null && aborted.doubleValue() != 0.0) {
                abortStr = "; ABORTED";
                if (errorMsg != null) {
                    abortStr = abortStr + "; " + ConsolePrinter.toString(errorMsg);
                }
            }
            me.print("finished experiment %d/%d in %.2fs%s", me.getNumTasksExecuted(), me.getNumTasks(), runTime, abortStr);
        }
    }

    private static String toString(Object o) {
        String res = o == null ? "null" : (o.getClass().isArray() ? Util.arrayToString(o) : o.toString());
        return res;
    }

    public MsgCategory getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(MsgCategory logLevel) {
        this.logLevel = logLevel;
    }

    public String getLogFormat() {
        return this.logFormat;
    }

    public void setLogFormat(String logFormat) {
        this.logFormat = logFormat;
    }

    public PrintWriter getOut() {
        return this.out;
    }

    public void setOut(PrintWriter out) {
        this.out = out;
    }

    public boolean isPrintStdEvents() {
        return this.printStdEvents;
    }

    public void setPrintStdEvents(boolean printStdEvents) {
        this.printStdEvents = printStdEvents;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public static void printResults(@Nullable Experiment e, Map<String, Object> res) {
        PrintWriter pw = new PrintWriter(System.out, true);
        try {
            ConsolePrinter.printResults(pw, e, res);
        }
        finally {
            pw.flush();
        }
    }

    public static void printResults(Map<String, Object> res) {
        ConsolePrinter.printResults((Experiment)null, res);
    }

    public static void printResults(PrintWriter out, @Nullable Experiment e, Map<String, Object> res) {
        Object v;
        out.println();
        if (e != null) {
            out.println(ConsolePrinter.getDescription(e));
        }
        ArrayList<String> valStatNames = new ArrayList<String>();
        ArrayList<String> otherNames = new ArrayList<String>();
        for (String k : res.keySet()) {
            if (k == "runTime") continue;
            v = res.get(k);
            if (v instanceof SummaryStat) {
                valStatNames.add(k);
                continue;
            }
            otherNames.add(k);
        }
        Collections.sort(valStatNames, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.compareToIgnoreCase(s2);
            }
        });
        Collections.sort(otherNames, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.compareToIgnoreCase(s2);
            }
        });
        if (valStatNames.size() > 0) {
            out.println();
            out.println("Name\tMean\tMin\tMax\tStdDev\tCount\tSum");
            for (String k : valStatNames) {
                SummaryStat vs = (SummaryStat)res.get(k);
                out.printf(I18n.DEF_LOCALE, "%s\t%.4f\t%.4f\t%.4f\t%.4f\t%d\t%.4f%n", k, vs.mean(), vs.min(), vs.max(), vs.stdDev(), vs.numObs(), vs.sum());
            }
        }
        if (otherNames.size() > 0) {
            out.println();
            out.println("Name\tValue");
            for (String k : otherNames) {
                v = res.get(k);
                if (v != null) {
                    if (v.getClass().isArray()) {
                        v = Util.arrayToString(v);
                    } else if (v instanceof Experiment) {
                        v = ConsolePrinter.getDescription((Experiment)v);
                    }
                }
                out.println(k + "\t" + v);
            }
        }
        out.println();
        out.printf(I18n.DEF_LOCALE, "time needed:\t%.1fs%n", res.get("runTime"));
        out.flush();
    }

    public static void printResults(PrintWriter out, Map<String, Object> res) {
        ConsolePrinter.printResults(out, null, res);
    }

    public static void printEventList(PrintWriter out, Simulation sim) {
        SimEvent curr = sim.currentEvent();
        List<SimEvent> nextEvents = sim.scheduledEvents();
        out.println();
        out.printf(I18n.DEF_LOCALE, "events (*-current, %d future):\n", nextEvents.size());
        out.println("time\tprio\ttype\tdescription");
        out.printf(I18n.DEF_LOCALE, "%s*\t%d\t%s\t%s\n", new Object[]{curr.getTime(), curr.getPrio(), curr.eventType(), curr.toString()});
        for (SimEvent evt : nextEvents) {
            out.printf(I18n.DEF_LOCALE, "%s\t%d\t%s\t%s\n", new Object[]{evt.getTime(), evt.getPrio(), evt.eventType(), evt.toString()});
        }
        out.println();
        out.flush();
    }

    public static void printEventList(Simulation sim) {
        ConsolePrinter.printEventList(new PrintWriter(System.out, true), sim);
    }

    public static String getDescription(Experiment e) {
        String s = e.getName() != null ? I18n.defFormat("Results of %s '%s'", e.getClass().getSimpleName(), e.getName()) : I18n.defFormat("Results of %s", e.getClass().getSimpleName());
        return s;
    }
}

