/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.util;

import jasima.core.util.i18n.I18n;
import java.util.EnumSet;
import java.util.Set;

public final class ComponentStates {
    public static <E extends Enum<E>> E requireAllowedState(E state, E allowed1) {
        return ComponentStates.requireAllowedState(state, allowed1, null, null);
    }

    public static <E extends Enum<E>> E requireAllowedState(E state, E allowed1, E allowed2) {
        return ComponentStates.requireAllowedState(state, allowed1, allowed2, null);
    }

    public static <E extends Enum<E>> E requireAllowedState(E state, E allowed1, E allowed2, E allowed3) {
        if (state != allowed1 && state != allowed2 && state != allowed3) {
            ComponentStates.raiseStateError(state, ComponentStates.createSet(allowed1, (Enum[])new Enum[]{allowed2, allowed3}));
        }
        return state;
    }

    @SafeVarargs
    public static <E extends Enum<E>> E requireAllowedState(E state, E allowed1, E ... allowedOther) {
        if (state == allowed1) {
            return state;
        }
        for (int i = 0; i < allowedOther.length; ++i) {
            if (state != allowedOther[i]) continue;
            return state;
        }
        ComponentStates.raiseStateError(state, ComponentStates.createSet(allowed1, allowedOther));
        throw new AssertionError();
    }

    public static <E extends Enum<E>> E requireAllowedState(E state, Set<E> allowedStates) {
        if (!allowedStates.contains(state)) {
            ComponentStates.raiseStateError(state, allowedStates);
        }
        return state;
    }

    @SafeVarargs
    private static <E extends Enum<E>> EnumSet<E> createSet(E allowed1, E ... allowedOther) {
        EnumSet<E> res = EnumSet.noneOf(allowed1.getDeclaringClass());
        res.add(allowed1);
        for (int i = 0; i < allowedOther.length; ++i) {
            if (allowedOther[i] == null) continue;
            res.add(allowedOther[i]);
        }
        return res;
    }

    private static <E extends Enum<E>> void raiseStateError(E state, Set<E> allowedStates) {
        throw new IllegalStateException(I18n.defFormat("Invalid state %s, allowed states: %s.", state, allowedStates));
    }

    private ComponentStates() {
    }
}

