/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.statistics;

import jasima.core.statistics.SummaryStat;
import jasima.core.util.i18n.I18n;

public class TimeWeightedSummaryStat
extends SummaryStat {
    private static final long serialVersionUID = -2192851354158356984L;
    private double lastTime;

    public TimeWeightedSummaryStat() {
    }

    public TimeWeightedSummaryStat(TimeWeightedSummaryStat s) {
        super(s);
        this.lastTime = s.lastTime;
    }

    @Override
    public void clear() {
        super.clear();
        this.lastTime = Double.NaN;
    }

    @Override
    public TimeWeightedSummaryStat value(double value, double time) {
        if (this.numObs() == 0) {
            super.value(value, 0.0);
        } else {
            if (time < this.lastTime()) {
                throw new IllegalArgumentException(I18n.defFormat("negative time span (lastTime=%f, time=%f).", this.lastTime(), time));
            }
            super.value(this.lastValue, time - this.lastTime());
        }
        this.lastTime = time;
        this.lastValue = value;
        return this;
    }

    @Override
    public TimeWeightedSummaryStat value(double v) {
        throw new UnsupportedOperationException("Use method TimeWeightedSummaryStat.value(double,double) instead.");
    }

    @Override
    public double min() {
        return Math.min(super.min(), this.lastValue);
    }

    @Override
    public double max() {
        return Math.max(super.max(), this.lastValue);
    }

    @Override
    public double variance() {
        return Double.NaN;
    }

    @Override
    public double variancePopulation() {
        return Double.NaN;
    }

    public double lastTime() {
        return this.lastTime;
    }

    @Override
    public TimeWeightedSummaryStat clone() {
        return (TimeWeightedSummaryStat)super.clone();
    }
}

