/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.statistics;

import java.io.Serializable;
import org.apache.commons.math3.distribution.TDistribution;

public class SummaryStat
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 817115058373461360L;
    protected static final double DEF_ERROR_PROB = 0.05;
    private double meanEst;
    private double varEst;
    private double weightSum;
    private int numObs;
    private double max;
    private double min;
    protected double lastValue;
    protected double lastWeight;

    public SummaryStat() {
        this.clear();
    }

    public SummaryStat(SummaryStat vs) {
        this();
        this.meanEst = vs.meanEst;
        this.varEst = vs.varEst;
        this.weightSum = vs.weightSum;
        this.numObs = vs.numObs;
        this.max = vs.max;
        this.min = vs.min;
        this.lastValue = vs.lastValue;
        this.lastWeight = vs.lastWeight;
    }

    public void clear() {
        this.meanEst = 0.0;
        this.varEst = 0.0;
        this.numObs = 0;
        this.weightSum = 0.0;
        this.min = Double.POSITIVE_INFINITY;
        this.max = Double.NEGATIVE_INFINITY;
        this.lastValue = Double.NaN;
        this.lastWeight = Double.NaN;
    }

    public SummaryStat values(double ... vs) {
        for (double v : vs) {
            this.value(v);
        }
        return this;
    }

    public SummaryStat value(double v) {
        return this.value(v, 1.0);
    }

    public SummaryStat value(double v, double weight) throws IllegalArgumentException {
        if (!(weight >= 0.0)) {
            throw new IllegalArgumentException("Weight can't be negative. " + weight);
        }
        this.lastValue = v;
        this.lastWeight = weight;
        ++this.numObs;
        if (v < this.min) {
            this.min = v;
        }
        if (v > this.max) {
            this.max = v;
        }
        double oldSum = this.weightSum;
        this.weightSum += weight;
        double q = v - this.meanEst;
        double r = this.weightSum == 0.0 ? 0.0 : q * weight / this.weightSum;
        this.meanEst += r;
        this.varEst += r * oldSum * q;
        return this;
    }

    public double mean() {
        if (this.numObs < 1) {
            return Double.NaN;
        }
        if (this.weightSum == 0.0) {
            return this.lastValue;
        }
        return this.meanEst;
    }

    public double stdDev() {
        return Math.sqrt(this.variance());
    }

    public double variance() {
        if (this.numObs == 1) {
            return 0.0;
        }
        if (this.numObs < 1 || this.weightSum <= 1.0) {
            return Double.NaN;
        }
        return this.varEst / (this.weightSum - 1.0);
    }

    public double variancePopulation() {
        if (this.numObs < 1) {
            return Double.NaN;
        }
        if (this.numObs == 1) {
            return 0.0;
        }
        return this.varEst / this.weightSum;
    }

    public double varCoeff() {
        return this.stdDev() / this.mean();
    }

    public double sum() {
        if (this.numObs < 1) {
            return Double.NaN;
        }
        return this.meanEst * this.weightSum;
    }

    public double weightSum() {
        if (this.numObs == 0) {
            return Double.NaN;
        }
        return this.weightSum;
    }

    public int numObs() {
        return this.numObs;
    }

    public double min() {
        if (this.numObs < 1) {
            return Double.NaN;
        }
        return this.min;
    }

    public double max() {
        if (this.numObs < 1) {
            return Double.NaN;
        }
        return this.max;
    }

    public SummaryStat combine(SummaryStat other) {
        double ws = this.weightSum + other.weightSum;
        double delta = other.meanEst - this.meanEst;
        this.meanEst = (this.meanEst * this.weightSum + other.meanEst * other.weightSum) / ws;
        this.varEst = this.varEst + other.varEst + delta * delta * this.weightSum * other.weightSum / ws;
        this.weightSum = ws;
        this.numObs += other.numObs;
        if (other.max > this.max) {
            this.max = other.max;
        }
        if (other.min < this.min) {
            this.min = other.min;
        }
        this.lastValue = other.lastValue;
        this.lastWeight = other.lastWeight;
        return this;
    }

    public SummaryStat clone() {
        try {
            return (SummaryStat)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public double confidenceIntervalLower() {
        return this.confidenceIntervalLower(0.05);
    }

    public double confidenceIntervalUpper() {
        return this.confidenceIntervalUpper(0.05);
    }

    public double confidenceIntervalLower(double errorProb) {
        return this.mean() - this.confIntRangeSingle(errorProb);
    }

    public double confidenceIntervalUpper(double errorProb) {
        return this.mean() + this.confIntRangeSingle(errorProb);
    }

    public double confIntRangeSingle(double errorProb) {
        if (this.numObs < 2) {
            return Double.NaN;
        }
        double deg = this.weightSum() - 1.0;
        TDistribution dist = new TDistribution(deg);
        return Math.abs(dist.inverseCumulativeProbability(errorProb * 0.5)) * Math.sqrt(this.variance() / this.weightSum());
    }

    public double lastValue() {
        if (this.numObs == 0) {
            return Double.NaN;
        }
        return this.lastValue;
    }

    public double lastWeight() {
        if (this.numObs == 0) {
            return Double.NaN;
        }
        return this.lastWeight;
    }

    public static SummaryStat summarize(double ... values) {
        return new SummaryStat().values(values);
    }

    public static SummaryStat summarize(int ... values) {
        SummaryStat res = new SummaryStat();
        for (int v : values) {
            res.value(v);
        }
        return res;
    }

    public static SummaryStat combine(SummaryStat stats1, SummaryStat stats2) {
        return new SummaryStat(stats1).combine(stats2);
    }
}

