/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.statistics;

import jasima.core.statistics.SummaryStat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Random;

public class SamplingSummaryStat
extends SummaryStat {
    private static final int DEF_NUM_SAMPLES = 100;
    private static final long serialVersionUID = 868112468971365852L;
    private int numSamples;
    private Random rnd;
    private PriorityQueue<DatEntry> data;
    private double threshold;

    public SamplingSummaryStat() {
        this(100, null);
    }

    public SamplingSummaryStat(int numSamples) {
        this(numSamples, null);
    }

    public SamplingSummaryStat(Random rnd) {
        this(100, rnd);
    }

    public SamplingSummaryStat(int numSamples, Random rnd) {
        this.setNumSamples(numSamples);
        this.setRnd(rnd);
    }

    @Override
    public SummaryStat value(double v, double weight) {
        throw new UnsupportedOperationException("Can't handle weights.");
    }

    @Override
    public SamplingSummaryStat value(double v) {
        double r;
        super.value(v, 1.0);
        if (this.data == null) {
            this.init();
        }
        double d = r = this.getRnd() == null ? Math.random() : this.getRnd().nextDouble();
        if (r < this.threshold || this.data.size() < this.getNumSamples()) {
            if (this.data.size() == this.getNumSamples()) {
                this.data.poll();
            }
            this.data.offer(new DatEntry(r, this.numObs(), v));
            this.threshold = this.data.peek().rand;
        }
        return this;
    }

    public double[] getData() {
        DatEntry[] tmp = this.data.toArray(new DatEntry[this.data.size()]);
        Arrays.sort(tmp, new Comparator<DatEntry>(){

            @Override
            public int compare(DatEntry o1, DatEntry o2) {
                if (o1.num < o2.num) {
                    return -1;
                }
                if (o1.num == o2.num) {
                    return 0;
                }
                return 1;
            }
        });
        double[] res = new double[tmp.length];
        for (int i = 0; i < tmp.length; ++i) {
            res[i] = tmp[i].data;
        }
        return res;
    }

    public void init() {
        this.data = new PriorityQueue(this.getNumSamples());
        this.threshold = 1.0;
    }

    public void setRnd(Random rnd) {
        this.rnd = rnd;
    }

    public Random getRnd() {
        return this.rnd;
    }

    public void setNumSamples(int numSamples) {
        if (numSamples <= 0) {
            throw new IllegalArgumentException("numSamples must be positive. " + numSamples);
        }
        this.numSamples = numSamples;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    @Override
    public SummaryStat clone() {
        throw new UnsupportedOperationException("clone()");
    }

    protected static class DatEntry
    implements Comparable<DatEntry> {
        public final double rand;
        public final int num;
        public final double data;

        public DatEntry(double r, int num, double rs) {
            this.rand = r;
            this.num = num;
            this.data = rs;
        }

        @Override
        public int compareTo(DatEntry o) {
            return Double.compare(o.rand, this.rand);
        }
    }
}

