/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.statistics;

import jasima.core.statistics.SummaryStat;
import jasima.core.util.i18n.I18n;
import java.util.Arrays;
import java.util.Formatter;
import java.util.Iterator;
import java.util.Locale;

public class QuantileEstimator
extends SummaryStat
implements Iterable<Bar> {
    private static final long serialVersionUID = 1342062250846464757L;
    protected double[] p2_q;
    protected int[] p2_n;
    protected double[] p2_n_increment;

    public QuantileEstimator() {
        this(0.05, 0.1, 0.25, 0.5, 0.75, 0.9, 0.95);
    }

    public QuantileEstimator(double ... quantiles) {
        this.setQuantileList(quantiles);
    }

    public void setQuantileList(double ... quantiles) {
        int i;
        Arrays.sort(quantiles);
        this.p2_n_increment = new double[quantiles.length * 2 + 3];
        this.p2_n_increment[0] = 0.0;
        for (i = 0; i < quantiles.length; ++i) {
            if (!(quantiles[i] >= 0.0) || !(quantiles[i] <= 1.0)) {
                throw new IllegalArgumentException("invalid quantile value: " + quantiles[i]);
            }
            this.p2_n_increment[i * 2 + 2] = quantiles[i];
        }
        this.p2_n_increment[this.p2_n_increment.length - 1] = 1.0;
        for (i = 1; i < this.p2_n_increment.length - 1; i += 2) {
            this.p2_n_increment[i] = (this.p2_n_increment[i - 1] + this.p2_n_increment[i + 1]) / 2.0;
        }
        this.initMarkers();
    }

    public double[] getQuantileList() {
        double[] retVal = new double[(this.p2_n_increment.length - 3) / 2];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = this.p2_n_increment[i * 2 + 2];
        }
        return retVal;
    }

    public void setCellCount(int cells) {
        assert (cells >= 2);
        this.p2_n_increment = new double[cells + 1];
        for (int i = 0; i < this.p2_n_increment.length; ++i) {
            this.p2_n_increment[i] = (double)i / ((double)this.p2_n_increment.length - 1.0);
        }
        this.initMarkers();
    }

    public int getCellCount() {
        return this.p2_q.length - 1;
    }

    @Override
    public SummaryStat combine(SummaryStat other) {
        throw new UnsupportedOperationException("combine(SummaryStat)");
    }

    @Override
    public QuantileEstimator clone() {
        throw new UnsupportedOperationException("clone()");
    }

    @Override
    public void clear() {
        if (this.numObs() > 0) {
            super.clear();
        }
        this.initMarkers();
    }

    protected void initMarkers() {
        assert (this.numObs() == 0);
        if (this.p2_n_increment != null) {
            if (this.p2_n == null || this.p2_n.length != this.p2_n_increment.length) {
                this.p2_n = new int[this.p2_n_increment.length];
            }
            if (this.p2_q == null || this.p2_q.length != this.p2_n_increment.length) {
                this.p2_q = new double[this.p2_n_increment.length];
            }
            for (int i = 0; i < this.p2_n.length; ++i) {
                this.p2_n[i] = i;
            }
        }
    }

    @Override
    public QuantileEstimator value(double v, double weight) {
        super.value(v, weight);
        int obsIdx = this.numObs() - 1;
        if (obsIdx < this.p2_q.length) {
            this.p2_q[obsIdx] = v;
            if (obsIdx == this.p2_q.length - 1) {
                Arrays.sort(this.p2_q);
            }
        } else {
            int k = Arrays.binarySearch(this.p2_q, v);
            if (k < 0) {
                k = -(k + 1);
            }
            if (k == 0) {
                this.p2_q[0] = v;
                k = 1;
            } else if (k == this.p2_q.length) {
                k = this.p2_q.length - 1;
                this.p2_q[k] = v;
            }
            int i = k;
            while (i < this.p2_n.length) {
                int n = i++;
                this.p2_n[n] = this.p2_n[n] + 1;
            }
            for (i = 1; i < this.p2_q.length - 1; ++i) {
                double n_ = this.p2_n_increment[i] * (double)obsIdx;
                double di = n_ - (double)this.p2_n[i];
                if (!(di >= 1.0 && this.p2_n[i + 1] - this.p2_n[i] > 1) && (!(di <= -1.0) || this.p2_n[i - 1] - this.p2_n[i] >= -1)) continue;
                int d = di < 0.0 ? -1 : 1;
                double qi_ = this.quadPred(d, i);
                if (qi_ < this.p2_q[i - 1] || qi_ > this.p2_q[i + 1]) {
                    qi_ = this.linPred(d, i);
                }
                this.p2_q[i] = qi_;
                int n = i;
                this.p2_n[n] = this.p2_n[n] + d;
            }
        }
        return this;
    }

    protected double quadPred(int d, int i) {
        double qi = this.p2_q[i];
        double qip1 = this.p2_q[i + 1];
        double qim1 = this.p2_q[i - 1];
        int ni = this.p2_n[i];
        int nip1 = this.p2_n[i + 1];
        int nim1 = this.p2_n[i - 1];
        double a = (double)(ni - nim1 + d) * (qip1 - qi) / (double)(nip1 - ni);
        double b = (double)(nip1 - ni - d) * (qi - qim1) / (double)(ni - nim1);
        return qi + (double)d * (a + b) / (double)(nip1 - nim1);
    }

    protected double linPred(int d, int i) {
        double qi = this.p2_q[i];
        double qipd = this.p2_q[i + d];
        int ni = this.p2_n[i];
        int nipd = this.p2_n[i + d];
        return qi + (double)d * (qipd - qi) / (double)(nipd - ni);
    }

    /*
     * WARNING - void declaration
     */
    public String getMarkers() {
        void var2_3;
        Formatter fmt = new Formatter(Locale.US);
        fmt.format("%5d", this.numObs());
        fmt.format(" |", new Object[0]);
        boolean bl = false;
        while (var2_3 < this.p2_n.length) {
            fmt.format("%8.2f", 1.0 + (double)(var2_3 * (this.numObs() - 1)) / ((double)this.p2_n.length - 1.0));
            ++var2_3;
        }
        fmt.format(" |", new Object[0]);
        for (int n : this.p2_n) {
            fmt.format("%5d", n + 1);
        }
        fmt.format(" |", new Object[0]);
        for (double q : this.p2_q) {
            fmt.format("%8.2f", q);
        }
        String string = fmt.toString();
        fmt.close();
        return string;
    }

    @Override
    public Iterator<Bar> iterator() {
        return new Iterator<Bar>(){
            private int bar = 0;
            private Bar retVal = new Bar();
            private double div = 1.0 / (double)QuantileEstimator.this.numObs();

            @Override
            public boolean hasNext() {
                return this.bar < QuantileEstimator.this.p2_n.length - 1;
            }

            @Override
            public Bar next() {
                this.retVal.minX = QuantileEstimator.this.p2_q[this.bar];
                this.retVal.maxX = QuantileEstimator.this.p2_q[this.bar + 1];
                this.retVal.area = (double)(QuantileEstimator.this.p2_n[this.bar + 1] - QuantileEstimator.this.p2_n[this.bar]) * this.div;
                ++this.bar;
                return this.retVal;
            }

            @Override
            public void remove() {
                assert (false);
            }
        };
    }

    public void formatForGnuplot(Formatter fmt) {
        for (Bar b : this) {
            fmt.format(Locale.US, "%6.4f %6.4f %6.4f%n", (b.minX + b.maxX) / 2.0, b.height(), b.width());
        }
    }

    public double quantile(double p) {
        if (Double.isNaN(p) || this.p2_n == null || this.numObs() < this.p2_n.length) {
            return Double.NaN;
        }
        if (p <= 0.0) {
            return this.p2_q[0];
        }
        if (p >= 1.0) {
            return this.p2_q[this.p2_q.length - 1];
        }
        int idx = Arrays.binarySearch(this.p2_n_increment, p);
        if (idx < 0) {
            int left = -idx - 2;
            int right = -idx - 1;
            double pl = this.p2_n_increment[left];
            double pr = this.p2_n_increment[right];
            return (this.p2_q[left] * (pr - p) + this.p2_q[right] * (p - pl)) / (pr - pl);
        }
        return this.p2_q[idx];
    }

    public String toString() {
        if (this.p2_q.length > 10) {
            return I18n.defFormat("[10%%<%f, median: %f, 90%%<%f; %d more markers]", this.quantile(0.1), this.quantile(0.5), this.quantile(0.9), this.p2_q.length - 3);
        }
        Formatter fmt = new Formatter();
        fmt.format("[", new Object[0]);
        for (int i = 2; i < this.p2_n_increment.length - 2; i += 2) {
            if (i != 2) {
                fmt.format("; ", new Object[0]);
            }
            fmt.format("%.0f%%<%f", this.p2_n_increment[i] * 100.0, this.p2_q[i]);
        }
        String retVal = fmt.format("]", new Object[0]).toString();
        fmt.close();
        return retVal;
    }

    public static class Bar {
        public double minX;
        public double maxX;
        public double area;

        public final double height() {
            return this.area / this.width();
        }

        public final double width() {
            return this.maxX - this.minX;
        }
    }
}

