/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.simulation.util;

import jasima.core.simulation.SimEvent;
import jasima.core.simulation.Simulation;
import java.time.Duration;

public class TimeSynchronizer {
    public static final int NUM_SYNC_EVENTS_PER_REAL_SECOND = 25;
    public static final long REAL_TIME_BETWEEN_SYNC_MILLIS = Math.round(40.0);
    private final Simulation sim;
    private double realTimeFactor;
    private long eventCounter;
    private long framesDropped;
    private double simTimeBetweenSync;
    private long tStartReal;
    private double tStartSim;
    private SimEvent syncEvent;

    public TimeSynchronizer(final Simulation sim, double realTimeFactor) {
        this.sim = sim;
        this.setRealTimeFactor(realTimeFactor);
        this.init();
        this.syncEvent = new SimEvent(this.tStartSim, -1610612733, "sync_event"){

            @Override
            public void handle() {
                TimeSynchronizer.this.syncTime();
                TimeSynchronizer.this.eventCounter++;
                double tNew = TimeSynchronizer.this.tStartSim + (double)TimeSynchronizer.this.eventCounter * TimeSynchronizer.this.simTimeBetweenSync;
                this.setTime(Math.max(tNew, sim.simTime()));
                sim.schedule(this);
            }

            @Override
            public boolean isAppEvent() {
                return false;
            }
        };
        sim.schedule(this.syncEvent);
        sim.valueStorePut("TimeSynchronizer", this);
    }

    private void init() {
        this.framesDropped = 0L;
        this.eventCounter = 0L;
        this.tStartReal = System.currentTimeMillis();
        this.tStartSim = this.sim.simTime();
        this.simTimeBetweenSync = this.sim.toSimTime(Duration.ofMillis(REAL_TIME_BETWEEN_SYNC_MILLIS)) * this.realTimeFactor;
    }

    protected void syncTime() {
        double realTimeDue = this.tStartReal + this.eventCounter * REAL_TIME_BETWEEN_SYNC_MILLIS;
        double timeDiff = realTimeDue - (double)System.currentTimeMillis();
        if (timeDiff > 0.0) {
            try {
                Thread.sleep(Math.round(timeDiff));
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        } else if (timeDiff < 0.0) {
            ++this.framesDropped;
        }
    }

    public double getRealTimeFactor() {
        return this.realTimeFactor;
    }

    public void setRealTimeFactor(double realTimeFactor) {
        this.realTimeFactor = realTimeFactor;
        this.init();
    }
}

