/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.simulation.util;

import jasima.core.random.continuous.DblSequence;
import jasima.core.simulation.SimComponent;
import jasima.core.simulation.SimComponentContainer;
import jasima.core.simulation.SimEntity;
import jasima.core.simulation.SimEvent;
import jasima.core.simulation.Simulation;
import jasima.core.simulation.util.SimEventMethodCall;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalUnit;
import java.util.Random;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import javax.annotation.Nullable;

public interface SimOperations {
    public Simulation getSim();

    default public SimComponentContainer getRootComponent() {
        return this.getSim().getRootComponent();
    }

    default public void addComponent(SimComponent ... scs) {
        this.getRootComponent().addChild(scs);
    }

    default public <T extends SimEntity> T activateEntity(T e) {
        this.getSim().activateEntity(e);
        return e;
    }

    default public void end() {
        this.getSim().end();
    }

    default public boolean isEndRequested() {
        return this.getSim().isEndRequested();
    }

    default public double simTime() {
        return this.getSim().simTime();
    }

    default public int currentPrio() {
        return this.getSim().currentPrio();
    }

    default public Instant simTimeAbs() {
        return this.simTimeToInstant(this.simTime());
    }

    default public Instant simTimeToInstant(double time) {
        return this.getSim().simTimeToInstant(time);
    }

    default public SimEvent schedule(SimEvent event) {
        return this.getSim().schedule(event);
    }

    default public SimEvent scheduleAt(double time, int prio, Runnable method) {
        return this.scheduleAt(null, time, prio, method);
    }

    default public SimEvent scheduleAt(double time, Runnable method) {
        return this.scheduleAt(time, this.currentPrio(), method);
    }

    default public SimEvent scheduleAt(@Nullable String description, double time, int prio, Runnable action) {
        return this.scheduleAt(description, time, prio, action, SimEventType.APP_EVENT);
    }

    default public SimEvent scheduleAt(@Nullable String description, double time, Runnable action) {
        return this.scheduleAt(description, time, this.currentPrio(), action);
    }

    default public SimEvent scheduleAt(double time, int prio, Runnable method, SimEventType eventType) {
        return this.scheduleAt(null, time, prio, method, eventType);
    }

    default public SimEvent scheduleAt(double time, Runnable method, SimEventType eventType) {
        return this.scheduleAt(time, this.currentPrio(), method, eventType);
    }

    default public SimEvent scheduleAt(@Nullable String description, double time, int prio, Runnable action, @Nullable SimEventType eventType) {
        SimEventMethodCall e = new SimEventMethodCall(time, prio, description, action, eventType != SimEventType.UTILITY_EVENT);
        return this.schedule(e);
    }

    default public SimEvent scheduleAt(@Nullable String description, double time, Runnable action, SimEventType eventType) {
        return this.scheduleAt(description, time, this.currentPrio(), action, eventType);
    }

    default public SimEvent scheduleAt(Instant time, int prio, Runnable method) {
        return this.scheduleAt(null, time, prio, method);
    }

    default public SimEvent scheduleAt(Instant time, Runnable method) {
        return this.scheduleAt(time, this.currentPrio(), method);
    }

    default public SimEvent scheduleAt(@Nullable String description, Instant time, int prio, Runnable method) {
        return this.scheduleAt(description, this.toSimTime(time), prio, method);
    }

    default public SimEvent scheduleAt(@Nullable String description, Instant time, Runnable method) {
        return this.scheduleAt(description, time, this.currentPrio(), method);
    }

    default public SimEvent scheduleAt(long numUnits, TemporalUnit unit, int prio, Runnable method) {
        return this.scheduleAt(null, numUnits, unit, prio, method);
    }

    default public SimEvent scheduleAt(long numUnits, TemporalUnit unit, Runnable method) {
        return this.scheduleAt(numUnits, unit, this.currentPrio(), method);
    }

    default public SimEvent scheduleAt(@Nullable String description, long numUnits, TemporalUnit unit, int prio, Runnable method) {
        return this.scheduleAt(description, this.toSimTime(numUnits, unit), prio, method);
    }

    default public SimEvent scheduleAt(@Nullable String description, long numUnits, TemporalUnit unit, Runnable method) {
        return this.scheduleAt(description, numUnits, unit, this.currentPrio(), method);
    }

    default public SimEvent scheduleIn(double time, int prio, Runnable method) {
        return this.scheduleIn(null, time, prio, method);
    }

    default public SimEvent scheduleIn(double time, Runnable method) {
        return this.scheduleIn(time, this.currentPrio(), method);
    }

    default public SimEvent scheduleIn(double time, int prio, Runnable method, SimEventType eventType) {
        return this.scheduleIn(null, time, prio, method, eventType);
    }

    default public SimEvent scheduleIn(double time, Runnable method, SimEventType eventType) {
        return this.scheduleIn(time, this.currentPrio(), method, eventType);
    }

    default public SimEvent scheduleIn(@Nullable String description, double time, int prio, Runnable method) {
        return this.scheduleIn(description, time, prio, method, SimEventType.APP_EVENT);
    }

    default public SimEvent scheduleIn(@Nullable String description, double time, Runnable method) {
        return this.scheduleIn(description, time, this.currentPrio(), method);
    }

    default public SimEvent scheduleIn(@Nullable String description, double time, int prio, Runnable method, SimEventType eventType) {
        return this.scheduleAt(description, this.simTime() + time, prio, method, eventType);
    }

    default public SimEvent scheduleIn(@Nullable String description, double time, Runnable method, SimEventType eventType) {
        return this.scheduleIn(description, time, this.currentPrio(), method, eventType);
    }

    default public SimEvent scheduleIn(Duration duration, int prio, Runnable method) {
        return this.scheduleIn(null, duration, prio, method);
    }

    default public SimEvent scheduleIn(Duration duration, Runnable method) {
        return this.scheduleIn(duration, this.currentPrio(), method);
    }

    default public SimEvent scheduleIn(@Nullable String description, Duration duration, int prio, Runnable method) {
        return this.scheduleIn(description, this.toSimTime(duration), prio, method);
    }

    default public SimEvent scheduleIn(@Nullable String description, Duration duration, Runnable method) {
        return this.scheduleIn(description, duration, this.currentPrio(), method);
    }

    default public SimEvent scheduleIn(long numUnits, TemporalUnit unit, int prio, Runnable method) {
        return this.scheduleIn(null, numUnits, unit, prio, method);
    }

    default public SimEvent scheduleIn(long numUnits, TemporalUnit unit, Runnable method) {
        return this.scheduleIn(numUnits, unit, this.currentPrio(), method);
    }

    default public SimEvent scheduleIn(@Nullable String description, long numUnits, TemporalUnit unit, int prio, Runnable method) {
        return this.scheduleIn(description, this.toSimTime(numUnits, unit), prio, method);
    }

    default public SimEvent scheduleIn(@Nullable String description, long numUnits, TemporalUnit unit, Runnable method) {
        return this.scheduleIn(description, numUnits, unit, this.currentPrio(), method);
    }

    default public void schedulePeriodically(double firstInvocation, double interval, int prio, BooleanSupplier method) {
        this.getSim().schedulePeriodically(firstInvocation, interval, prio, method);
    }

    default public void schedulePeriodically(double firstInvocation, double interval, int prio, Runnable method) {
        this.getSim().schedulePeriodically(firstInvocation, interval, prio, method);
    }

    default public void scheduleProcess(int prio, DoubleSupplier method) {
        this.getSim().scheduleProcess(prio, method);
    }

    default public void scheduleProcess(double firstInvocation, int prio, DoubleSupplier method) {
        this.getSim().scheduleProcess(firstInvocation, prio, method);
    }

    default public double toSimTime(Instant instant) {
        return this.getSim().toSimTime(instant);
    }

    default public double toSimTime(Duration d) {
        return this.getSim().toSimTime(d);
    }

    default public double toSimTime(long numUnits, TemporalUnit u) {
        return this.getSim().toSimTime(numUnits, u);
    }

    default public void addResult(String name, Object value) {
        this.getSim().addResult(name, value);
    }

    default public void trace(Object ... params) {
        this.getSim().trace(params);
    }

    default public boolean isTraceEnabled() {
        return this.getSim().isTraceEnabled();
    }

    default public <T extends DblSequence> T initRndGen(T s, String streamName) {
        return this.getSim().initRndGen(s, streamName);
    }

    default public Random initRndGen(String streamName) {
        return this.getSim().initRndGen(streamName);
    }

    public static enum SimEventType {
        APP_EVENT,
        UTILITY_EVENT;

    }
}

