/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.simulation.util;

import jasima.core.simulation.SimContext;
import jasima.core.simulation.SimProcess;
import jasima.core.simulation.Simulation;
import jasima.core.util.SimProcessUtil;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface ProcessActivator {
    public static final Logger log = LogManager.getLogger(ProcessActivator.class);

    public Simulation getSim();

    default public SimProcess<Void> activate(SimProcessUtil.SimRunnable r) {
        return this.activateCallable(null, SimProcessUtil.simCallable(r));
    }

    default public SimProcess<Void> activate(String name, SimProcessUtil.SimRunnable r) {
        return this.activateCallable(name, SimProcessUtil.simCallable(r));
    }

    default public <T> SimProcess<T> activate(SimProcessUtil.SimAction a) {
        return this.activateCallable(null, SimProcessUtil.simCallable(a));
    }

    default public <T> SimProcess<T> activate(String name, SimProcessUtil.SimAction a) {
        return this.activateCallable(name, SimProcessUtil.simCallable(a));
    }

    default public <T> SimProcess<T> activateCallable(Callable<T> c) {
        return this.activateCallable(null, SimProcessUtil.simCallable(c));
    }

    default public <T> SimProcess<T> activateCallable(String name, Callable<T> c) {
        return this.activateCallable(name, SimProcessUtil.simCallable(c));
    }

    default public <T> SimProcess<T> activateCallable(SimProcessUtil.SimCallable<T> a) {
        return this.activateCallable(null, a);
    }

    default public <T> SimProcess<T> activateCallable(String name, SimProcessUtil.SimCallable<T> a) {
        Simulation ctxSim = SimContext.currentSimulation();
        if (ctxSim != null && ctxSim != this.getSim()) {
            throw new IllegalStateException();
        }
        SimProcess p = new SimProcess(this.getSim(), a, name);
        FutureTask<SimProcess> f = new FutureTask<SimProcess>(() -> {
            p.awakeIn(0.0);
            return p;
        });
        if (ctxSim == null) {
            this.getSim().runInSimThread(() -> f.run());
        } else {
            f.run();
        }
        if (ctxSim != null) {
            try {
                f.get();
            }
            catch (InterruptedException | ExecutionException e) {
                log.error("there was a problem activating a process", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return p;
    }
}

