/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.simulation.generic;

import jasima.core.simulation.SimEvent;
import jasima.core.simulation.SimProcess;
import jasima.core.simulation.Simulation;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;

public class ResourceNonBlocking {
    private static final int DEF_CHECK_FULFILMENT_PRIO = 0;
    private Simulation sim;
    private Deque<Request> waitingRequests = new ArrayDeque<Request>();
    private int capacityTotal;
    private int capacityInUse;
    private Map<Request, Request> currentlyProcessed = new IdentityHashMap<Request, Request>();
    private boolean scheduledCheckFulfilment = false;
    private SimEvent checkFulfilmentEvent = new SimEvent(Double.NaN, 0, "CHECK_FULFILMENT"){

        @Override
        public void handle() {
            ResourceNonBlocking.this.scheduledCheckFulfilment = false;
            ResourceNonBlocking.this.checkFulfilment();
        }
    };

    public ResourceNonBlocking() {
        this(1);
    }

    public ResourceNonBlocking(int totalCapacity) {
        this.capacityTotal = totalCapacity;
        this.capacityInUse = 0;
    }

    public boolean canAcquire(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException("Capacity has to be positive: " + capacity);
        }
        return capacity <= this.capacityAvailable();
    }

    public int capacityAvailable() {
        return this.capacityTotal - this.capacityInUse;
    }

    public int capacityTotal() {
        return this.capacityTotal;
    }

    public Request get(int amount, BiConsumer<ResourceNonBlocking, Request> onAvailableCallback) {
        Request request = new Request(amount, Objects.requireNonNull(onAvailableCallback));
        this.waitingRequests.add(request);
        this.scheduleFulfilmentCheck();
        return request;
    }

    public void put(Request req) {
        if (req.state != Request.RequestState.PROCESSING) {
            throw new IllegalArgumentException("Invalid request state.");
        }
        boolean removeRes = this.currentlyProcessed.remove(req, req);
        if (!removeRes) {
            throw new IllegalArgumentException("Request not processed.");
        }
        this.capacityInUse -= req.amount;
        req.state = Request.RequestState.FINISHED;
        this.scheduleFulfilmentCheck();
    }

    public void scheduleFulfilmentCheck() {
        int checkPrio = Math.max(0, this.sim.currentPrio() + 1000);
        if (this.checkFulfilmentEvent.getPrio() != checkPrio || !this.scheduledCheckFulfilment) {
            if (this.scheduledCheckFulfilment) {
                boolean removeRes = this.sim.unschedule(this.checkFulfilmentEvent);
                assert (removeRes);
                this.scheduledCheckFulfilment = false;
            }
            this.checkFulfilmentEvent.setPrio(checkPrio);
            this.sim.schedule(this.checkFulfilmentEvent);
            this.scheduledCheckFulfilment = true;
        }
    }

    protected void checkFulfilment() {
        Request r;
        int available = this.capacityAvailable();
        while (this.waitingRequests.size() > 0 && available > 0 && (r = this.waitingRequests.peekFirst()).amount <= available) {
            this.waitingRequests.removeFirst();
            this.currentlyProcessed.put(r, r);
            r.state = Request.RequestState.PROCESSING;
            available -= r.amount;
            this.capacityInUse += r.amount;
            r.onAvailableCallback.accept(this, r);
        }
    }

    public void acquire(int amount) throws SimProcess.MightBlock {
    }

    public void release(int amount) throws SimProcess.MightBlock {
    }

    public Simulation getSim() {
        return this.sim;
    }

    public void setSim(Simulation sim) {
        this.sim = sim;
    }

    public int getCapacityTotal() {
        return this.capacityTotal;
    }

    public void setCapacityTotal(int capacityTotal) {
        this.capacityTotal = capacityTotal;
    }

    public static class Request {
        private RequestState state = RequestState.NEW;
        private final int amount;
        private final BiConsumer<ResourceNonBlocking, Request> onAvailableCallback;

        public Request(int amount, BiConsumer<ResourceNonBlocking, Request> onAvailableCallback) {
            this.amount = amount;
            this.onAvailableCallback = onAvailableCallback;
        }

        public static enum RequestState {
            NEW,
            WAITING,
            PROCESSING,
            FINISHED,
            CANCELLED;

        }
    }
}

