/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.simulation.generic;

import jasima.core.simulation.SimContext;
import jasima.core.simulation.SimProcess;
import jasima.core.simulation.generic.Q;

public class Resource {
    private Q<SimProcess<?>> seizedBy = new Q();

    public Resource(String string, int numResources) {
        this.setCapacity(numResources);
    }

    public Resource(String string) {
        this(string, 1);
    }

    public void seize() throws SimProcess.MightBlock {
        Q.enter(this.seizedBy);
    }

    public boolean trySeize() {
        SimProcess<?> p = SimContext.currentProcess();
        return this.seizedBy.tryPut(p);
    }

    public void release() {
        Q.leave(this.seizedBy);
    }

    public void seize(int numResources) throws SimProcess.MightBlock {
        if (numResources < 1) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < numResources; ++i) {
            this.seize();
        }
    }

    public boolean trySeize(int numResources) {
        if (numResources < 1) {
            throw new IllegalArgumentException();
        }
        if (this.numAvailable() < numResources) {
            return false;
        }
        for (int i = 0; i < numResources; ++i) {
            this.trySeize();
        }
        return true;
    }

    public void release(int numResources) {
        if (numResources < 1) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < numResources; ++i) {
            this.release();
        }
    }

    public int numAvailable() {
        return this.seizedBy.numAvailable();
    }

    public int getCapacity() {
        return this.seizedBy.getCapacity();
    }

    public void setCapacity(int numResources) {
        this.seizedBy.setCapacity(numResources);
    }
}

