/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.simulation.generic;

import jasima.core.simulation.SimLifecycleListener;
import jasima.core.simulation.Simulation;
import jasima.core.simulation.generic.Q;
import jasima.core.statistics.TimeWeightedSummaryStat;

public class QLengthStatsCollector {
    private final Q<?> q;
    private final Simulation sim;
    private final TimeWeightedSummaryStat numItems;

    public QLengthStatsCollector(Q<?> q, Simulation sim) {
        this.q = q;
        this.sim = sim;
        this.numItems = new TimeWeightedSummaryStat();
        q.addListener((queue, event) -> {
            if (event == Q.QEvents.ITEM_ADDED || event == Q.QEvents.ITEM_REMOVED) {
                this.recordValue();
            }
        });
        this.recordValue();
        sim.addListener(SimLifecycleListener.ResultsListener.class, res -> res.put(q.toString() + ".qLength", this.statsNumItems()));
    }

    private void recordValue() {
        this.numItems.value(this.q.numItems(), this.sim.simTime());
    }

    public TimeWeightedSummaryStat statsNumItems() {
        TimeWeightedSummaryStat stats = new TimeWeightedSummaryStat(this.numItems);
        stats.value(this.q.numItems(), this.sim.simTime());
        return stats;
    }
}

