/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.simulation.generic;

import jasima.core.simulation.SimContext;
import jasima.core.simulation.SimProcess;
import jasima.core.util.observer.Notifier;
import jasima.core.util.observer.NotifierImpl;
import jasima.core.util.observer.NotifierListener;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.math3.exception.NotPositiveException;

public class Q<T>
implements Notifier<Q<T>, QEvent> {
    private int capacity = -1;
    private String name = null;
    private Deque<T> items = new ArrayDeque<T>();
    private List<SimProcess<?>> awaitingTake = new ArrayList();
    private List<SimProcess<?>> awaitingPut = new ArrayList();
    private T lastAdded = null;
    private T lastRemoved = null;
    private NotifierImpl<Q<T>, QEvent> notifierImpl = new NotifierImpl(this);

    public static void enter(Q<SimProcess<?>> q) throws SimProcess.MightBlock {
        SimProcess<?> proc = SimContext.currentProcess();
        q.put(proc);
    }

    public static void leave(Q<SimProcess<?>> q) {
        SimProcess<?> proc = SimContext.currentProcess();
        boolean removed = q.remove(proc);
        if (!removed) {
            throw new IllegalStateException();
        }
    }

    public static <T> QListener<T> traceQEvents(Q<T> q1) {
        return q1.addListener(new QListener<T>(){

            @Override
            public void itemAdded(Q<T> q, T item) {
                this.addTraceEntry("queue.added", q, item);
            }

            @Override
            public void itemRemoved(Q<T> q, T item) {
                this.addTraceEntry("queue.removed", q, item);
            }

            @Override
            public void handleOther(Q<T> q, QEvent event) {
                this.addTraceEntry("queue.other", q, event);
            }

            private void addTraceEntry(String event, Q<?> q, Object item) {
                SimContext.trace(event, item, q, q.numItems(), q.numWaitingPut(), q.numWaitingTake());
            }
        });
    }

    public Q() {
    }

    public Q(String name) {
        this();
        this.setName(name);
    }

    public void put(T t) throws SimProcess.MightBlock {
        SimProcess<?> p = SimContext.currentProcess();
        if (this.numAvailable() <= 0) {
            this.awaitingPut.add(p);
            while (this.numAvailable() <= 0) {
                p.suspend();
            }
            this.awaitingPut.remove(p);
        }
        boolean putRes = this.tryPut(t);
        assert (putRes);
    }

    public boolean tryPut(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        if (this.numAvailable() <= 0) {
            return false;
        }
        this.items.addLast(t);
        this.itemAdded(t);
        return true;
    }

    public void putFront(T t) throws SimProcess.MightBlock {
        SimProcess<?> p = SimContext.currentProcess();
        if (this.numAvailable() <= 0) {
            this.awaitingPut.add(p);
            while (this.numAvailable() <= 0) {
                p.suspend();
            }
            this.awaitingPut.remove(p);
        }
        boolean putRes = this.tryPutFront(t);
        assert (putRes);
    }

    public boolean tryPutFront(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        if (this.numAvailable() <= 0) {
            return false;
        }
        this.items.addFirst(t);
        this.itemAdded(t);
        return true;
    }

    public T take() throws SimProcess.MightBlock {
        SimProcess<?> p = SimContext.currentProcess();
        if (this.numItems() == 0) {
            this.awaitingTake.add(p);
            while (this.numItems() == 0) {
                p.suspend();
            }
            this.awaitingTake.remove(p);
        }
        T res = this.tryTake();
        assert (res != null);
        return res;
    }

    @Nullable
    public T tryTake() {
        if (this.numItems() == 0) {
            return null;
        }
        T res = this.items.removeFirst();
        this.itemRemoved(res);
        return res;
    }

    public T takeLast() throws SimProcess.MightBlock {
        SimProcess<?> p = SimContext.currentProcess();
        if (this.numItems() == 0) {
            this.awaitingTake.add(p);
            while (this.numItems() == 0) {
                p.suspend();
            }
            this.awaitingTake.remove(p);
        }
        T res = this.tryTakeLast();
        assert (res != null);
        return res;
    }

    @Nullable
    public T tryTakeLast() {
        if (this.numItems() == 0) {
            return null;
        }
        T res = this.items.removeLast();
        this.itemRemoved(res);
        return res;
    }

    public boolean remove(T t) {
        boolean res = this.items.remove(t);
        if (res) {
            this.itemRemoved(t);
        }
        return res;
    }

    private void itemAdded(T t) {
        this.lastAdded = t;
        this.fire(QEvents.ITEM_ADDED);
        this.resumeTakeProcesses();
    }

    private void itemRemoved(T t) {
        this.lastRemoved = t;
        this.fire(QEvents.ITEM_REMOVED);
        this.resumePutProcesses();
    }

    private void resumeTakeProcesses() {
        this.awaitingTake.stream().filter(p -> p.processState() == SimProcess.ProcessState.PASSIVE).forEach(SimProcess::resume);
    }

    private void resumePutProcesses() {
        this.awaitingPut.stream().filter(p -> p.processState() == SimProcess.ProcessState.PASSIVE).forEach(SimProcess::resume);
    }

    public int numItems() {
        return this.items.size();
    }

    public T get(int n) {
        if (n < 0) {
            throw new NotPositiveException((Number)n);
        }
        T res = null;
        Iterator<T> it = this.items.iterator();
        for (int i = 0; i <= n; ++i) {
            res = it.next();
        }
        return res;
    }

    public int numAvailable() {
        return this.capacity < 0 ? Integer.MAX_VALUE : Math.max(this.capacity - this.items.size(), 0);
    }

    public int numWaitingTake() {
        return this.awaitingTake.size();
    }

    public int numWaitingPut() {
        return this.awaitingPut.size();
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int newCapacity) {
        int oldAvailable = this.numAvailable();
        this.capacity = newCapacity;
        if (oldAvailable < this.numAvailable()) {
            this.resumePutProcesses();
        }
    }

    @Override
    public Notifier<Q<T>, QEvent> notifierImpl() {
        return this.notifierImpl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.getName() != null ? this.getName() : super.toString();
    }

    public static interface QListener<T>
    extends NotifierListener<Q<T>, QEvent> {
        @Override
        default public void inform(Q<T> q, QEvent event) {
            if (event == QEvents.ITEM_ADDED) {
                this.itemAdded(q, ((Q)q).lastAdded);
            } else if (event == QEvents.ITEM_REMOVED) {
                this.itemRemoved(q, ((Q)q).lastRemoved);
            } else {
                this.handleOther(q, event);
            }
        }

        default public void itemAdded(Q<T> q, T item) {
        }

        default public void itemRemoved(Q<T> q, T item) {
        }

        default public void handleOther(Q<T> q, QEvent event) {
        }

        @FunctionalInterface
        public static interface ItemRemoved<T>
        extends QListener<T> {
            @Override
            public void itemRemoved(Q<T> var1, T var2);
        }

        @FunctionalInterface
        public static interface ItemAdded<T>
        extends QListener<T> {
            @Override
            public void itemAdded(Q<T> var1, T var2);
        }
    }

    public static enum QEvents implements QEvent
    {
        ITEM_ADDED,
        ITEM_REMOVED;

    }

    public static interface QEvent {
    }
}

