/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.simulation.generic;

import jasima.core.util.observer.DerivedObservable;
import jasima.core.util.observer.ObservableValue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class ConditionQueue {
    private final ObservableValue<Boolean> condition;
    private final List<Runnable> actions;
    private final ObservableValue.ObservableListener<Boolean> changeListener;
    private boolean listenerInstalled;

    public ConditionQueue(Supplier<Boolean> boolExpression, ObservableValue<?> ... exprDependencies) {
        this(new DerivedObservable<Boolean>(boolExpression, exprDependencies));
    }

    public ConditionQueue(ObservableValue<Boolean> condition) {
        this.condition = Objects.requireNonNull(condition);
        this.changeListener = this::onConditionChanged;
        this.actions = new ArrayList<Runnable>();
        this.listenerInstalled = false;
    }

    public boolean executeWhenTrue(Runnable action) {
        Objects.requireNonNull(action);
        boolean result = this.condition.get();
        this.actions.add(action);
        if (!this.listenerInstalled) {
            this.condition.addWeakListener(this.changeListener);
            this.listenerInstalled = true;
        }
        if (result) {
            this.runActions();
        }
        return result;
    }

    public int numActions() {
        return this.actions.size();
    }

    private void onConditionChanged(ObservableValue<Boolean> sender, ObservableValue.EventType event) {
        assert (ObservableValue.EventType.VALUE_CHANGED.equals((Object)event) || ObservableValue.EventType.MIGHT_HAVE_CHANGED.equals((Object)event));
        if (this.condition.get().booleanValue()) {
            this.runActions();
        }
    }

    private void runActions() {
        Iterator<Runnable> it = this.actions.iterator();
        while (it.hasNext() && this.condition.get().booleanValue()) {
            Runnable action = it.next();
            action.run();
            it.remove();
        }
    }
}

