/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.simulation.generic;

import jasima.core.simulation.SimContext;
import jasima.core.simulation.SimProcess;
import jasima.core.simulation.generic.ConditionQueue;
import jasima.core.util.observer.ObservableValue;
import java.util.ArrayDeque;
import java.util.Deque;

public class Channel<MSG> {
    private Deque<MSG> msgs = new ArrayDeque<MSG>();
    private ObservableValue<Boolean> hasMsgs = new ObservableValue<Boolean>(Boolean.FALSE);
    private ConditionQueue waitQueue = new ConditionQueue(this.hasMsgs);

    public void send(MSG msg) {
        this.msgs.addLast(msg);
        this.hasMsgs.set(Boolean.TRUE);
    }

    public MSG receive() throws SimProcess.MightBlock {
        if (this.msgs.size() == 0) {
            assert (!this.hasMsgs.get().booleanValue());
            SimProcess<?> currentProcess = SimContext.currentProcess();
            this.waitQueue.executeWhenTrue(() -> currentProcess.resume());
            currentProcess.suspend();
        } else assert (this.waitQueue.numActions() == 0);
        MSG msg = this.msgs.removeFirst();
        this.hasMsgs.set(this.msgs.size() > 0);
        return msg;
    }
}

