/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.simulation.arrivalprocess;

import jasima.core.random.continuous.DblSequence;
import jasima.core.simulation.arrivalprocess.ArrivalProcess;
import java.util.Random;
import org.apache.commons.math3.analysis.UnivariateFunction;

public class ArrivalsNonStationary
extends ArrivalProcess {
    private static final long serialVersionUID = -4530103049458748815L;
    private DblSequence unitMeanDblStream;
    private UnivariateFunction inverseCumulativeExpectation;

    @Override
    public double nextDbl() {
        if (!this.isFirst || !this.isArrivalAtTimeZero()) {
            this.state += this.unitMeanDblStream.nextDbl();
        }
        this.isFirst = false;
        return this.inverseCumulativeExpectation.value(this.state);
    }

    @Override
    public void init() {
        super.init();
        this.unitMeanDblStream.setRndGen(this.rndGen);
        this.unitMeanDblStream.init();
    }

    @Override
    public DblSequence clone() {
        ArrivalsNonStationary c = (ArrivalsNonStationary)super.clone();
        if (this.unitMeanDblStream != null) {
            c.unitMeanDblStream = this.unitMeanDblStream.clone();
        }
        return c;
    }

    public DblSequence getUnitMeanDblStream() {
        return this.unitMeanDblStream;
    }

    public void setUnitMeanDblStream(DblSequence unitMeanDblStream) {
        this.unitMeanDblStream = unitMeanDblStream;
    }

    public UnivariateFunction getInverseCumulativeExpectation() {
        return this.inverseCumulativeExpectation;
    }

    public void setInverseCumulativeExpectation(UnivariateFunction inverseCumulativeExpectation) {
        this.inverseCumulativeExpectation = inverseCumulativeExpectation;
    }

    @Override
    public void setRndGen(Random rndGen) {
        super.setRndGen(rndGen);
        if (this.unitMeanDblStream != null) {
            this.unitMeanDblStream.setRndGen(rndGen);
        }
    }
}

